#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gjutil.h>

int GJindex(char *str,char c);

float mzcons(unsigned char *pos,int n)

/* calculate conservation value according to Zvelebil et al for a set
   of amino acids and gaps stored in string pos of length n
*/

{

/* --  conmat contains a table like that shown in the JMB paper
       order of amino acids is GAP,ARNDCQEGHILKMFPSTWYBZX
*/
    static char *acids = " ARNDCQEGHILKMFPSTWYBZX";
    static int conmat[24][10] = {
	{1,1,1,1,1,1,1,1,1,1},
	{1,0,0,0,0,1,1,0,0,0},
	{0,1,0,1,1,0,0,0,0,0},
	{0,0,0,1,0,1,0,0,0,0},
	{0,0,1,1,1,1,0,0,0,0}, 
	{1,0,0,0,0,1,0,0,0,0},
	{0,0,0,1,0,0,0,0,0,0},
	{0,0,1,1,1,0,0,0,0,0},
	{1,0,0,0,0,1,1,0,0,0}, 
	{1,1,0,1,1,0,0,0,1,0},
	{1,0,0,0,0,0,0,1,0,0},
	{1,0,0,0,0,0,0,1,0,0},
	{1,1,0,1,1,0,0,0,0,0},
	{1,0,0,0,0,0,0,0,0,0},
	{1,0,0,0,0,0,0,0,1,0},
	{0,0,0,0,0,1,0,0,0,1},
	{0,0,0,1,0,1,1,0,0,0},
	{1,0,0,1,0,1,0,0,0,0},
	{1,0,0,1,0,0,0,0,1,0},
	{1,0,0,1,0,0,0,0,1,0},
	{1,0,0,0,0,1,0,1,0,0},
	{0,0,0,1,0,0,0,0,0,0},
	{0,0,0,1,0,0,0,0,0,0},
	{1,1,1,1,1,1,1,1,1,1}
    };

    int concnt,it,i,j,k,l,tcnt,ibseq;
    int nide, facid;

    concnt = 0;
    for(j=0;j<10;++j){
	/*found: outer loop over properties
	set IT to the value of the first amino acid*/
	it = conmat[GJindex(acids,pos[0])][j];
	/*loop over remaining acids, if a difference occurs then
        set tcnt to 1*/
        tcnt = 0;
        for(k=1;k<n;++k){
           if(it != conmat[GJindex(acids,pos[k])][j]){
                tcnt = 1;
	   }
	}
	/*add tcnt to concnt*/
        concnt += tcnt;
    }
    /* check for total identity at this position*/
    facid = pos[0];
    nide = 0;
    for(k=1;k<n;++k){
	if(facid == pos[k]){
             ++nide;
	}
    }

    /*calculate the conservation*/
    if(concnt == 10){
      con = 0.0;
    }else if(concnt == 0){
	if(nide == n){
	    /*total identity*/
            con = 1.0;
	}else{
            /*not identity, but same properties*/
              con = 0.9;
	}
    }else{
        con = 0.9 - 0.1 * concnt;
    }
    return con;
}


int GJindex(char *str,char c)
{
    char *t;
    t = strchr(str,c);
    if(t == NULL) return NULL;
    return (int) (t - str);
}
