#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>

#include <gjutil.h>
#include <gjtimes.h>


/* timing routines */

struct tms *t_init = NULL;
struct tms *t_last = NULL;
struct tms *t_new = NULL;

clock_t init_times,last_times, new_times;

void GJ_init_times(void)
{

  extern struct tms *t_init, *t_last, *t_new;
  extern clock_t init_times, last_times, new_times;

  if(t_init == NULL){
    t_init = (struct tms *) GJmalloc(sizeof(struct tms));
    t_new = (struct tms *) GJmalloc(sizeof(struct tms));
    t_last = (struct tms *) GJmalloc(sizeof(struct tms));

    init_times = times(t_init);
    new_times = init_times;
    last_times = init_times;
  
    copy_tms(t_last,t_init);
    copy_tms(t_new,t_init);
  }
}

void copy_tms(struct tms *l,struct tms *r)
{
  l->tms_utime = r->tms_utime;
  l->tms_stime = r->tms_stime;
  l->tms_cutime = r->tms_cutime;
  l->tms_cstime = r->tms_cstime;
}


void GJ_show_times(FILE *fp,int action)
{
  /* show the time(s) since init_times was called
     if action = 0, print the time since the last call to GJ_init_times
                    or GJ_show_times.
     if action = 1, print as in 0, but add the total time since the
                    first call to GJ_init_times.
        action = 2, print elapsed and total time +
	            tms_utime, tms_stime, tms_cutime and tms_cstime
  */

  clock_t init_calling, new_calling, last_calling;
  clock_t init_child, new_child, last_child;

  extern struct tms *t_init, *t_last, *t_new;
  extern clock_t init_times, last_times, new_times;

  new_times = times(t_new);
   
  if(action == 0){
    fprintf(fp,"Elapsed time: %*6.2f\n",
	    (float)(new_times-last_times)/CLK_TCK);
  }

  if(action == 1){
    /* compressed output - shows summary of user + sys for parent and child */
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;



     fprintf(fp,"CPU(P%*7.1f%*7.1f)(C%*7.1f%*7.1f)(T%*7.1f%*7.1f)(E%*7.1f%*7.1f)\n",
	     (float)(new_calling - last_calling)/CLK_TCK,
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_child - last_child)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-last_calling+new_child-last_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK,
	     (float)(new_times-last_times)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);
  }


  if(action == 2){
    /* full output */
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;



     fprintf(fp,"         %7s:%7s:%7s|%7s:%7s:%7s:%7s:%7s\n",
	     "user","sys","total","c user","c sys","ctotal","el/tcpu","cum");
     fprintf(fp,"Master  :%*7.1f:%*7.1f:%*7.1f|%*7.1f:%*7.1f:%*7.1f|%*7.1f:%*7.1f\n",
	     (float)(t_new->tms_utime - t_last->tms_utime)/CLK_TCK,
	     (float)(t_new->tms_stime - t_last->tms_stime)/CLK_TCK,
	     (float)(new_calling - last_calling)/CLK_TCK,
	     (float)(t_new->tms_utime - t_init->tms_utime)/CLK_TCK,
	     (float)(t_new->tms_stime - t_init->tms_stime)/CLK_TCK,
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_times-last_times)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);

     fprintf(fp,"Children:%*7.1f:%*7.1f:%7.1f|%*7.1f:%*7.1f:%7.1f|%*7.1f:%*7.1f\n",
	     (float)(t_new->tms_cutime - t_last->tms_cutime)/CLK_TCK,
	     (float)(t_new->tms_cstime - t_last->tms_cstime)/CLK_TCK,
	     (float)(new_child - last_child)/CLK_TCK,
	     (float)(t_new->tms_cutime - t_init->tms_cutime)/CLK_TCK,
	     (float)(t_new->tms_cstime - t_init->tms_cstime)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-last_calling+new_child-last_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK);
  }
  if(action == 3){
    /* very compressed output - shows cumparent, cumchild + sum of the two  and elapsed time summary*/
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;

     fprintf(fp,"Cum CPU Time: Parent: %*7.1f Child: %*7.1f Total: %*7.1f Elapsed: %7.1f\n",
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);
  }

  copy_tms(t_last,t_new);
  last_times = new_times;
}


char *GJ_get_times(int action)
{
  /* show the time(s) since init_times was called
     if action = 0, print the time since the last call to GJ_init_times
                    or GJ_show_times.
     if action = 1, print as in 0, but add the total time since the
                    first call to GJ_init_times.

  */

  clock_t init_calling, new_calling, last_calling;
  clock_t init_child, new_child, last_child;

  char *outbuf;

  extern struct tms *t_init, *t_last, *t_new;
  extern clock_t init_times, last_times, new_times;

  new_times = times(t_new);

  outbuf = (char *) GJmalloc(sizeof(char) *200);
   
  if(action == 0){
    sprintf(outbuf,"%*7.1f\0",
	    (float)(new_times-last_times)/CLK_TCK);
  }
#ifdef KEEP_THIS
  if(action == 1){
    /* compressed output - shows summary of user + sys for parent and child */
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;

     sprintf(outbuf,"%*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f\0",
	     (float)(new_calling - last_calling)/CLK_TCK,
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_child - last_child)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-last_calling+new_child-last_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK,
	     (float)(new_times-last_times)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);
  }
#else
  /* this is a version that ignores the child processes since these 
     appear not to be reported on the SGI */
  if(action == 1){
    /* compressed output - shows summary of user + sys for parent and child */
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;

     sprintf(outbuf,"%*7.1f %*7.1f %*7.1f %*7.1f\0",
	     (float)(new_calling - last_calling)/CLK_TCK,
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_times-last_times)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);
  }
#endif

  if(action == 2){
    /* full output */
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;



     sprintf(outbuf,
     "%*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f %*7.1f",
	     (float)(t_new->tms_utime - t_last->tms_utime)/CLK_TCK,
	     (float)(t_new->tms_stime - t_last->tms_stime)/CLK_TCK,
	     (float)(new_calling - last_calling)/CLK_TCK,
	     (float)(t_new->tms_utime - t_init->tms_utime)/CLK_TCK,
	     (float)(t_new->tms_stime - t_init->tms_stime)/CLK_TCK,
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_times-last_times)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK,
	     (float)(t_new->tms_cutime - t_last->tms_cutime)/CLK_TCK,
	     (float)(t_new->tms_cstime - t_last->tms_cstime)/CLK_TCK,
	     (float)(new_child - last_child)/CLK_TCK,
	     (float)(t_new->tms_cutime - t_init->tms_cutime)/CLK_TCK,
	     (float)(t_new->tms_cstime - t_init->tms_cstime)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-last_calling+new_child-last_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK);
  }

  if(action == 3){
    /* very compressed output - shows cumparent, cumchild + sum of the two  and elapsed time summary*/
     init_calling = t_init->tms_utime + t_init->tms_stime;
     init_child = t_init->tms_cutime + t_init->tms_cstime;

     last_calling = t_last->tms_utime + t_last->tms_stime;
     new_calling = t_new->tms_utime + t_new->tms_stime;

     last_child = t_last->tms_cutime + t_last->tms_cstime;
     new_child = t_new->tms_cutime + t_new->tms_cstime;

     sprintf(outbuf,"%*7.1f %*7.1f %*7.1f %7.1f\0",
	     (float)(new_calling - init_calling)/CLK_TCK,
	     (float)(new_child - init_child)/CLK_TCK,
	     (float)(new_calling-init_calling+new_child-init_child)/CLK_TCK,
	     (float)(new_times-init_times)/CLK_TCK);
  }

  copy_tms(t_last,t_new);
  last_times = new_times;
  outbuf = (char *) GJrealloc(outbuf,sizeof(char) * (strlen(outbuf) + 1));
  return outbuf;
}

void GJ_reset_times()
{
    extern struct tms *t_init, *t_new, *t_last;

    if(t_init != NULL){
      GJfree(t_init);
      t_init = NULL;
    }
    if(t_new != NULL){
      GJfree(t_new);
      t_new = NULL;
    }
    if(t_last != NULL){
      GJfree(t_last);
      t_last = NULL;
    }
}
#define DELETE
#ifndef DELETE
main(int argc,char **argv)
{
  int i,j;
  float l;
  GJ_init_times();
  /*  fprintf(stderr,"(0)%s\n",GJ_get_times(0));*/
  /*  fprintf(stderr,"(1)%s\n",GJ_get_times(1));*/
  /*  fprintf(stderr,"(2)%s\n",GJ_get_times(2));*/
  fprintf(stderr,"(3)%s\n",GJ_get_times(3));

  for(i=0;i<5000;++i){
    for(j=0;j<5000;++j){
      l = i*j;
    }
  }
  /*  fprintf(stderr,"(0)%s\n",GJ_get_times(0));*/
  /*  fprintf(stderr,"(1)%s\n",GJ_get_times(1));*/
  /*  fprintf(stderr,"(2)%s\n",GJ_get_times(2));*/
  fprintf(stderr,"(3)%s\n",GJ_get_times(3));
  for(i=0;i<10000;++i){
    for(j=0;j<5000;++j){
      l = i*j;
    }
  }
  /*  fprintf(stderr,"(0)%s\n",GJ_get_times(0));*/
  /*  fprintf(stderr,"(1)%s\n",GJ_get_times(1));*/
  /*  fprintf(stderr,"(2)%s\n",GJ_get_times(2));*/
  fprintf(stderr,"(3)%s\n",GJ_get_times(3));
  GJ_reset_times();
}
#endif





