#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_ID_LEN 20           /* Protein ID Length			   */
#define MAX_TITLE_LEN 500       /* Protein Title Line			   */
#define MAX_SEQ_LEN   8000      /* Sequence Length	 		   */
#define MAX_CLUST_NO 50		/* max number of clusters to analyse	   */
#define MAX_CLUST_SIZE 200      /* max number of sequences in a cluster	   */
#define MAX_NSEQ 1000           /* Number of Proteins		 	   */
#define MAX_BLOC_SEQ 1000       /* max number of sequences is a blocfile   */
#define SMALL -100000

/******************************************************************************/
/* These used to live in array.h                                              */

#define MAXnseq 1000 
#define MAXslen 8000
#define MAXilen 1000
#define MAXtlen 1000
#define MAXnbloc 1000

/******************************************************************************/
/* Standard structure for storing protein sequence data		  */

#ifndef _ARRAY_H
struct seqdat {	   /* all lengths include char terminator and [0] */
    int ilen;	   /* length of identifier                        */
    char *id;	   /* identifier                                  */
    int tlen;	   /* length of title                             */
    char *title;   /* title                                       */
    int slen;      /* length of sequence                          */
    char *seq;     /* sequence                                    */
};
#endif

/* Zvelebil Conservation Value Store		  		  */

struct zv {
    int *zva;                   /* ZCVs in cluster A              */
    int *zvb;                   /* ZCVs in cluster B		  */
};

/* cluster member index						  */

struct indclust {
        int number;             /* number of members in cluster	  */
        int *order;             /* list of sequence numbers which */
				/* are members of cluster	  */
        };

/* Structure for storing property type matrix data			    */

struct pmtrx {
    int  pcode;        /* Symbol to which the property types are assigned   */
    int *ptype;        /* Property type matrix				    */
    };
struct slist {
    char *aas;         /* list of amino acid symbols used in matrix pmtrx   */
    char **pnames;     /* property type name				    */
    int pno;           /* number of struct pmtrx records ie. property types */
    int maxnoprop;     /* maximum number of symbols per property	    */
    int syno;          /* number of symbol types across *ptype matrix	    */
    struct pmtrx *apm; /* array of property matrices			    */
    };
struct defaults {
    char **font;	/* define 4 fonts   */
    char **cols;      /* define 7 colours */
    float *grey;      /* define 4 shades  */ 
    int uot;	/* use original titling method? */
    char *nt1;	/* replacement title line 1 */
    char *nt2;	/* replacement title line 2 */
    char *nt3;	/* replacement title line 2 */
    char *pty;  /* ptype dir location */
    char *dfs;  /* defaults location */
    char *AlscC;  /* alscript command line */
    };
struct slist readprop();

/* structure for storing residues tested in zvel.c */

struct resisto {
    char **resiclust;	/* two dimensional array containing, for each       */
			/* sub-group, a list of the residues tested there   */
    };

/******************************************************************************/
