# include "includes.h"

/***************************************************************************/
/* Define sequence subsets - only works for 1-99 sequences per subset!!!   */
/***************************************************************************/

void zcalc(bloc,cl,intcons,same,diff,count,nbloc,ptype,noclust,
           gcut,neg,point,atyp,consval,resipos)

int **intcons,**same,**diff;
int count,noclust,gcut,neg,point,atyp,nbloc,consval;
struct slist ptype;
struct seqdat *bloc;
struct indclust *cl;
struct resisto *resipos;
{
  char **rA,**rB,**rN;
  int  *zva,*zvb,*zto,*zlist;
  int  nl,ny,mn,ml,mu,mx,fla,flb,sync,zno,ma;

/***************************************************************************/
/*         allocate structure to store conservation value returns          */
/***************************************************************************/

  zva=(int*) malloc (sizeof(int)*(count+3));
  zvb=(int*) malloc (sizeof(int)*(count+3));
  zto=(int*) malloc (sizeof(int)*(count+3));

  rN = (char**) malloc (sizeof(char*)*(count+1));
  for(nl=1;nl<count+1;++nl)
    rN[nl]=(char*) malloc(sizeof(char)*(ptype.syno));
  rA = (char**) malloc (sizeof(char*)*(count+1));
  for(nl=1;nl<count+1;++nl)
    rA[nl]=(char*) malloc(sizeof(char)*(ptype.syno));
  rB = (char**) malloc (sizeof(char*)*(count+1));
  for(nl=1;nl<count+1;++nl)
    rB[nl]=(char*) malloc(sizeof(char)*(ptype.syno));

/**************************************************************************/
/*  Generate data for plot...                                             */
/**************************************************************************/

  sync=-1;
  printf("Execution: calculating conservation values...\n");



/**************************************************************************/
/*This loop will only activate if the number of clusters is greater than 1*/
/*This is because the loop condition is that mn must be less than noclust */
/*but mn starts at 1, so when noclust is 1 mn is never less than it       */
/**************************************************************************/

  for(mn=1;mn<noclust;++mn){
    for(ml=mn+1;ml<noclust+1;++ml){
  
      for(mu=1;mu<count+3;++mu){zva[mu]=-1;zvb[mu]=-1;zto[mu]=-1;}  
      for(mu=1;mu<count+1;++mu)
        for(ny=0;ny<ptype.syno;++ny){rA[mu][ny]=-1;rB[mu][ny]=-1;rN[mu][ny]=-1;}

      sync++; 

/* calculate conservation values for separate sub-groups */
    
      zvel(zva,bloc,cl[mn].number,cl[mn].order,
           count,ptype,gcut,neg,point,nbloc,atyp,1,rA,resipos,mn,consval);

      zvel(zvb,bloc,cl[ml].number,cl[ml].order,
           count,ptype,gcut,neg,point,nbloc,atyp,1,rB,resipos,ml,consval);

      for(mu=0;mu<count+1;mu++)

/* Store all conservation values in appropriate array. */
    
      for(mu=0;mu<count+1;++mu){
        intcons[mn][mu]=zva[mu];
        intcons[noclust][mu]=zvb[mu];
      }

      for(mu=1;mu<count+1;++mu){
        if(zva[mu]>point)
          zva[mu]=point; 
        if(zvb[mu]>point) 
          zvb[mu]=point; 
      }

      zno=cl[mn].number + cl[ml].number;    
      zlist = (int*) malloc(sizeof(int)*(zno+2));
      for(mu=1;mu<zno+1;++mu)zlist[mu]=0;
      for(mu=1;mu<cl[mn].number+1;++mu) zlist[mu]=cl[mn].order[mu];
      mx=mu; 
      for(mu=1;mu<cl[ml].number+1;++mu){
        zlist[mx]=cl[ml].order[mu];
        mx++;
      }

      printf("           - for groups %d and %d ...\n",mn,ml);

      for(nl=1;nl<count+1;++nl)
        for(mu=0;mu<ptype.syno;++mu){
          if((rA[nl][mu]==1)&&(rB[nl][mu]==1)){rN[nl][mu]=1;}else
          if((rA[nl][mu]==1)&&(rB[nl][mu]==0)){rN[nl][mu]=1;}else
          if((rA[nl][mu]==0)&&(rB[nl][mu]==1)){rN[nl][mu]=1;}else
          rN[nl][mu]=-1;
        }

/* calculate conservation values of group formed by pair of sub-groups */

      zvel(zto,bloc,zno,zlist,count,ptype,gcut,neg,
           point,nbloc,atyp,2,rN,resipos,0,consval);


/*      for(ma=1;ma<nbloc+1;ma++){
        for(mu=1;mu<count+1;mu++)
          printf("%5c",bloc[ma].seq[mu]);
        printf("\n");
      }
      printf("GP:%d:   ",mn);
      for(mu=1;mu<count+1;mu++)
        printf("%5d",intcons[mn][mu]);
      printf("\nGP:%d:   ",ml);
      for(mu=1;mu<count+1;mu++)
        printf("%5d",intcons[noclust][mu]);

      printf("\nGP:%d&%d:   ",mn,ml);
      for(mu=1;mu<count+1;mu++)
        printf("%5d",zto[mu]);
      printf("\n\n"); 
*/
      for(mu=1;mu<count+1;++mu){

/* determine how many gaps are in the sequences */
/* (should this be here at all?!!)              */

        fla=0;
        for(mx=1;mx<cl[mn].number+1;++mx)
          if(bloc[cl[mn].order[mx]].seq[mu]==' ')fla++;
        flb=0;
        for(mx=1;mx<cl[ml].number+1;++mx)
          if(bloc[cl[ml].order[mx]].seq[mu]==' ')flb++;

/* if the number of gaps is equal to the number of sequences in a subgroup */
/* or the conservation value of the subgroup is less than the conservation */
/* cutoff, set the conservation value to a null value - the sub-group will */
/* be ignored								   */

        if((fla>=cl[mn].number)||(zva[mu]<consval)){
           zva[mu]=-1;
        }
        if((flb>=cl[ml].number)||(zvb[mu]<consval)){
           zvb[mu]=-1;
        }

/* determine similarity/difference status of the components of the pair */

        if((zva[mu]>=consval)&&(zvb[mu]>=consval)){
     
/* defines similarities */

          if((zto[mu]>=zva[mu])||(zto[mu]>=zvb[mu])){
            same[sync][mu]=zto[mu];
          }else same[sync][mu]=-1;

/* defines differences  */

          if((fla<cl[mn].number)&&(flb<cl[ml].number)&&
            (zto[mu]<zva[mu])&&(zto[mu]<zvb[mu])){
            diff[sync][mu]=zto[mu];
          }else diff[sync][mu]=-1;

/*          printf("%5d",zto[mu]); */

        }
      }
      free((char*) zlist);
    }
  }

/* end of loop in which conservation numbers are normally calculated */



/**************************************************************************/
/*  free memory                                                           */
/**************************************************************************/

  free((char*) zva);
  free((char*) zvb);
  free((char*) zto); 
  for(nl=1;nl<count+1;++nl)
    {free((char*) rA[nl]);free((char*) rB[nl]);free((char*) rN[nl]);}
  free((char*) rA);
  free((char*) rB);
  free((char*) rN);
}
