# include "includes.h"


#define TOKENS "\" ,\n\t" 
#define TOK2 "\",\n\t"
#define N_FONT 4
#define N_COLS 9
#define N_GREY 6



int MAXnseq  = MAX_NSEQ;
int MAXilen  = MAX_ID_LEN;
int MAXslen  = MAX_SEQ_LEN;
int MAXnbloc = MAX_BLOC_SEQ;
int MAXtlen  = MAX_TITLE_LEN; 
int MAXcno   = MAX_CLUST_NO;
int MAXcsz   = MAX_CLUST_SIZE;

main(argc, argv)
int argc;
char *argv[];
{ 
  FILE *in,*fp;
  int mn,mu,mx,bn,xx,zz,splat,datout,edat,count,strf;
  int aa,noclust,nostruc,nbloc,pin,point,fset,sto;
  int idflag,pretty,mask,consval,neg,other,tostr,ssno,stroff;	    
  int gcut,shade,hscale,port,color,hist,atyp,ssif,aloff;
  int *mka,*mkb;
  int **intcons,**same,**diff;
  char *blocfile,*pfile,*tcn,*outname,*num,*ssid,*strcr,*nnote;
  char *tmpname,*extn,*buff,*sbuff,*token,cc;
  char cnos[N_COLS+1],fnos[N_FONT];
  float fsto;
  float ps; 
  struct indclust *cl;
  struct indclust *ss;
  struct seqdat *bloc;
  struct slist  ptype;
  struct defaults def;
  struct resisto *resipos;

  printf("\n\nAMAS (Analysis of Multiply Aligned Sequences)\n\n");
  printf(    "      Version 1.67b - August 2000            \n");
  printf(    "      See README   for instructions          \n");
  printf(    "    By:  C.D.Livingstone & G.J.Barton        \n\n");
  printf(    "Copyright: (c) G.J.Barton & C.D.Livingstone 1992,1997 \n\n\n\n");


/***************************************************************************/
/* Define Default Fonts &c. Get Environment                                */
/***************************************************************************/

/* obtain path location of amas defaults and property type tables */

    def.dfs = getenv("AMASDEFAULTS");
    if(def.dfs == NULL){
      printf("Error: must define environment");
      printf(" variable AMASDEFAULTS before running AMAS\n");
      exit(0);
    }
    def.pty = getenv("AMASPTYPE");
    if(def.pty == NULL){
      printf("Error: must define environment");
      printf(" variable AMASPTYPE before running AMAS\n");
      exit(0);
    }
    def.AlscC = getenv("ALSCRIPTCOMMAND");
    if(def.AlscC == NULL){
      printf("Error: must define environment");
      printf(" variable ALSCRIPTCOMMAND before running AMAS\n");
      exit(0);
    }

/* set up defaults variables */

    def.font = (char**) malloc (sizeof(char*)*N_FONT);
    def.cols = (char**) malloc (sizeof(char*)*(N_COLS+1));
    def.grey = (float*) malloc (sizeof(float)*(N_GREY+1));
    def.uot  = 0;ssif=0;strf=-1;
    buff = (char *) malloc(100 * sizeof(char));
    if(buff == NULL){
      printf("\nError: No Space for buff\n");
      exit(0);
    }
    sbuff = (char *) malloc(100 * sizeof(char));
    if(sbuff == NULL){
      printf("\nError: No Space for sbuff\n");
      exit(0);
    }
    if((fp = fopen(def.dfs, "r")) == NULL){
	fprintf(stderr,"\nError: Can't open Parameter file: %s\n",def.dfs);
	return 0;
    }
    for(mu=0;mu<N_FONT;mu++)fnos[mu]=0;
    for(mu=0;mu<N_COLS;mu++)cnos[mu]=0;
    for(mu=0;mu<N_GREY;mu++)def.grey[mu]=-1;

/* get values for defaults variables */

    while(buff = fgets(buff,99,fp)){
      strcpy(sbuff,buff);
      if(buff == NULL) break;
      token = strtok(buff,TOKENS);
      if(token == NULL) break;

/* get identifier for secondary structure sequence (if present) */

      if(strcmp(token,"SSI") == 0){
        token = strtok(NULL,TOK2);
        ssid = (char*) malloc(sizeof(char)*(strlen(token)+2));
        strcpy(ssid,token);
        ssid[strlen(token)]='\0';
        ssif=1;
      }

/* get identifier for secondary structure sequence (if present) */

      if(strcmp(token,"STRCR") == 0){
        token = strtok(NULL,TOK2);
        strcr = (char*) malloc(sizeof(char)*(strlen(token)+2));
        strcpy(strcr,token);
        strcr[strlen(token)]='\0';
        strf=strlen(strcr);
      }

/* get 4 font types */

      if(strcmp(token,"DEFINE_FONT") == 0){
        token = strtok(NULL,TOKENS);
        sto = atoi(token);
        if((sto<N_FONT)&&(sto>-1)){
          def.font[sto] = (char*) malloc (sizeof(char)*(strlen(sbuff)+1));
          strcpy(def.font[sto],sbuff);
          fnos[sto]=1;
        } else {
          printf("\nError: only fonts 0 to 3 are available\n");
          printf("       can not set font %d...\n",sto);
          exit(0);
        }
      }

/* get 7 colours */

      if(strcmp(token,"DEFINE_COLOUR") == 0){
        token = strtok(NULL,TOKENS);
        sto = atoi(token);
        if((sto<N_COLS+1)&&(sto>0)){
          def.cols[sto] = (char*) malloc (sizeof(char)*(strlen(sbuff)+1));
          strcpy(def.cols[sto],sbuff);
          cnos[sto]=1;
          for(mu=0;mu<3;++mu){
            token = strtok(NULL,TOKENS);
            fsto = atof(token);
            if((fsto<0)||(fsto>1)){
              printf("\nError: colour values fall");
              printf(" outside acceptable range 0-1\n");
              exit(0);
            }
          }
        } else {
          printf("\nError: only fonts 1 to 7 are available\n");
          printf("       can not set font %d...\n",sto);
          exit(0);
        }
      }

/* get 4 shades *//* make alterations here!!! */

      if(strcmp(token,"DEFINE_SHADE") == 0){
        token = strtok(NULL,TOKENS);
        sto = atoi(token);
        if((sto<N_GREY+1)&&(sto>0)){
          token = strtok(NULL,TOKENS);
          def.grey[sto]= atof(token);
          if((def.grey[sto]<0)||(def.grey[sto]>1)){
            printf("\nError: grey scale values fall");
            printf(" outside acceptable range 0-1\n");
            exit(0);
          }
        } else {
          printf("\nError: only shades 1 to 4 are available\n");
          printf("       can not set font %d...\n",sto);
          exit(0);
        }
      }

/* get user defined titling to replace standard two lines at base of plot */

      if(strcmp(token,"USER_TITLE_1") == 0){
        token = strtok(NULL,TOK2);
        def.nt1 = (char*) malloc (sizeof(char)*(strlen(token)+1));
        strcpy(def.nt1,token);
      }
      if(strcmp(token,"USER_TITLE_2") == 0){
        token = strtok(NULL,TOK2);
        def.nt2 = (char*) malloc (sizeof(char)*(strlen(token)+1));
        strcpy(def.nt2,token);
      }
      if(strcmp(token,"USER_TITLE_3") == 0){
        token = strtok(NULL,TOK2);
        def.nt3 = (char*) malloc (sizeof(char)*(strlen(token)+1));
        strcpy(def.nt3,token);
      }
    }

/* report errors in defaults settings */

    cc=0;
    for(mu=0;mu<N_FONT;mu++)if(fnos[mu]==1)cc++;
    if(cc!=N_FONT){
      printf("\nError: %d fonts set.   You must set fonts 0-%d\n",cc,N_FONT-1);
      exit(0);
    }
    cc=0;
    for(mu=1;mu<N_COLS+1;mu++)if(cnos[mu]==1)cc++;
    if(cc!=N_COLS){
      printf("\nError: %d colours set.  You must set colours 1-%d\n",cc,N_COLS);
      exit(0);
    }
    cc=0;
    for(mu=1;mu<N_GREY+1;mu++)if((int)def.grey[mu]!=-1)cc++;

/* alter number of shades set!!! */

    if(cc!=N_GREY){
      printf("\nError: %d shade set.  You must set shades 1-%d\n",cc,N_GREY);
      exit(0);
    }
    fclose(fp);



/***************************************************************************/
/* Interpret the command line                                              */
/***************************************************************************/

/* option variables initialised */

  idflag=0;def.uot=0;tostr=0;pretty=1;shade=0;neg=1;fset=0;datout=0;
  hscale=10;mask=0;port=0;color=0;edat=0;gcut=0;mx=-1;hist=0;atyp=0;
  other=0;aloff=0;

/* scan the options field of the command line */

  if(argc>=2){
    for(mu=0;mu<strlen(argv[1])+1;++mu){
      if((argv[1][mu]=='a')||(argv[1][mu]=='A')){
        num = (char*) malloc (sizeof(char));
        bn=mu+1;mx=1;
        while((argv[1][bn]>='0')&&(argv[1][bn]<='9')){
            num[mx-1]=argv[1][bn];
            mx++;
            num = (char*) realloc(num,(sizeof(char)*mx));
            num[mx-1]='\0';
            bn++;
        }
        if((mx>1)&&((atoi(num)>0)||(strcmp(num,"0")==0))){atyp=atoi(num);}
        mu=bn-1;
        printf("Execution: minimum residence ");
        printf("percentage for a residue in a group set to %d...\n",atyp);
        free((char*)num);
      }
      if((argv[1][mu]=='c')||(argv[1][mu]=='C'))color=1;
      if((argv[1][mu]=='d')||(argv[1][mu]=='D'))datout=1;
      if((argv[1][mu]=='e')||(argv[1][mu]=='E'))edat=1;
      if((argv[1][mu]=='f')||(argv[1][mu]=='F'))fset=1;
      if((argv[1][mu]=='g')||(argv[1][mu]=='G')){
        num = (char*) malloc (sizeof(char));
        bn=mu+1;
        mx=1;
        while((argv[1][bn]>='0')&&(argv[1][bn]<='9')){
            num[mx-1]=argv[1][bn];
            mx++;
            num = (char*) realloc(num,(sizeof(char)*(mx+1)));
            num[mx-1]='\0';
            bn++;
        }
        if((mx>1)&&(atoi(num)>=0))gcut=atoi(num);
        mu=bn-1;
        printf("Execution: setting gap skip ");
        printf("number to %d gaps per group...\n",gcut);
        free((char*)num);
      }
      if((argv[1][mu]=='h')||(argv[1][mu]=='H')){
        num = (char*) malloc (sizeof(char));
        hist=1;
        bn=mu+1;mx=1;
        while((argv[1][bn]>='0')&&(argv[1][bn]<='9')){
            num[mx-1]=argv[1][bn];
            mx++;
            num = (char*) realloc(num,(sizeof(char)*(mx+1)));
            num[mx-1]='\0';
            bn++;
        }
        if((mx>1)&&(atoi(num)>=0)){hscale=atoi(num);}
        mu=bn-1;
        printf("Execution: setting histogram");
        printf(" scale to %d lines per graph...\n",hscale);
        if(hscale==0)hist=-1;
        free((char*)num);
      }
      if((argv[1][mu]=='i')||(argv[1][mu]=='I'))idflag=1;
      if((argv[1][mu]=='m')||(argv[1][mu]=='M'))mask=1;
      if((argv[1][mu]=='n')||(argv[1][mu]=='N'))neg=0;
      if((argv[1][mu]=='o')||(argv[1][mu]=='O'))other=1;
      if((argv[1][mu]=='p')||(argv[1][mu]=='P'))port=1;
      if((argv[1][mu]=='r')||(argv[1][mu]=='R'))tostr=1;
      if((argv[1][mu]=='s')||(argv[1][mu]=='S'))shade=1;
      if((argv[1][mu]=='t')||(argv[1][mu]=='T'))pretty=0;
      if((argv[1][mu]=='u')||(argv[1][mu]=='U'))def.uot=1;
      if((argv[1][mu]=='v')||(argv[1][mu]=='V'))hist=-1;
      if((argv[1][mu]=='x')||(argv[1][mu]=='X'))aloff=1;
      if((argv[1][mu]=='y')||(argv[1][mu]=='Y'))aloff=2;
      if((argv[1][mu]=='z')||(argv[1][mu]=='Z'))aloff=3;
    }
  }

/* check number of arguments, exit if incorrect */

  if((argc<6)||(argc>8)){
    printf("\n\nUsage: amas [options:a*cfg*h*imnopstuv]");
    printf("<alignment><ptable>\n");
    printf("           <sgfile><cons>[size][file rootname]\n");
    exit(0);
  }

/* interpret remainder of command line */

  blocfile = (char*) malloc (sizeof(char)*(strlen(argv[2])+1));
  strcpy(blocfile,argv[2]);
  blocfile[strlen(argv[2])]='\0';
  pfile = (char*) malloc (sizeof(char)*(strlen(argv[3])+2+strlen(def.pty)));
  strcpy(pfile,def.pty);
  strcat(pfile,"/");
  strcat(pfile,argv[3]);
  pfile[strlen(argv[3])+strlen(def.pty)+1]='\0';
  nnote = (char*) malloc (sizeof(char)*(strlen(argv[3])+1));
  strcpy(nnote,argv[3]);
  tcn = (char*) malloc (sizeof(char)*(strlen(argv[4])+1));
  strcpy(tcn,argv[4]);
  tcn[strlen(argv[4])]='\0';
  consval = atoi(argv[5]);

  if((pretty==0)&&(fset==0)&&(argc!=6)){
    printf("\n\nUsage: amas [options:-t-afgin]<alignment><ptable>\n");
    printf("                <sgfile><consval>\n");
    exit(0);
  }
  else if((pretty==1)&&(fset==0)){
    if(argc!=7){
      printf("\n\nUsage: amas [options:a*cg*h*imnopsuv]");
      printf("<alignment><ptable>\n");
      printf("                <sgfile><consval>[size]\n");
      exit(0);
    }
    ps = atof(argv[6]);
  }
  else if((pretty==0)&&(fset==1)){
    if(argc!=7){
      printf("\n\nUsage: amas [options:-ft-a*g*in]<alignment><ptable>\n");
      printf("                <sgfile><consval>[file rootname]\n");
      exit(0);
    }
    tmpname = (char*) malloc (sizeof(char)*(strlen(argv[6])+1));
    strcpy(tmpname,argv[6]);
    tmpname[strlen(argv[6])]='\0';
  }
  else if((pretty==1)&&(fset==1)){
    if(argc!=8){
      printf("\n\nUsage: amas [options:-f-a*cg*h*imnopsuv]");
      printf("<alignment><ptable>\n");
      printf("                <sgfile><consval>[size][fname]\n");
      exit(0);
    }
    ps = atof(argv[6]);
    tmpname = (char*) malloc (sizeof(char)*(strlen(argv[7])+1));
    strcpy(tmpname,argv[7]);
    tmpname[strlen(argv[7])]='\0';
  } 
  if((hist==0)&&((datout==1)||(edat==1)||(tostr==1))){
    printf("\n\nError: pattern data requires histogram option...\n");
    exit(0);
  }

/***************************************************************************/
/* Allocate memory for structure bloc and use subfunction "son of getbloc" */
/* (sog) (Getbloc was written by Geoff Barton (LMB Oxford)) to read        */ 
/* alignment into it                                                       */
/***************************************************************************/  

  printf("Execution: reading alignment \"%s\"...\n",blocfile);
  if((in = fopen(blocfile,"r")) == 0){ 
    printf("\n\nFile error: could not open  \"%s\" for input.\n",
      blocfile);
    exit(0);
  }
  bloc = (struct seqdat *) malloc(sizeof(struct seqdat) * MAXnbloc);
  if((char*) bloc == 0){
    printf("\n\nMemory overflow: no space into which to read \"%s\".\n",
      blocfile);
    exit(0);
  }
  if(!getbloc(in,bloc,&nbloc,blocfile,&count)){
    printf("\n\nFile error:  \"%s\" could not be read.",blocfile);
    exit(0);
  }
  if(fset==1){
    blocfile = (char*) realloc(blocfile,sizeof(char)*(strlen(tmpname)+2));
    strcpy(blocfile,tmpname);
    blocfile[(strlen(tmpname)+1)]='\0';
  }
  if(((aloff==1)||(aloff==2))&&(strf==-1)){
    printf("Error: must list secondary structure code in AMAS ");
    printf("file for options x and y\n");
    exit(0);
  }

/***************************************************************************/
/* check for existance of other copies of files - warn of overwrites       */
/***************************************************************************/

  ftest(blocfile);

/***************************************************************************/
/* Define sequence subsets                                                 */
/***************************************************************************/

  printf("Execution: interpreting groups from \"%s\"...\n",tcn); 


  cl= (struct indclust*) malloc(sizeof(struct indclust)*(MAXcno+1));
  for(mu=1;mu<MAXcno+1;++mu){
    cl[mu].order = (int*) malloc(sizeof(int)*(MAXcsz+1));
    cl[mu].number=0;
  }
  ss= (struct indclust*) malloc(sizeof(struct indclust)*(MAXcno+1));
  for(mu=0;mu<MAXcno+1;++mu){
    ss[mu].order = (int*) malloc(sizeof(int)*(MAXcsz+1));
    for(mx=0;mx<MAXcsz+1;++mx)ss[mu].order[mx]=0;
    ss[mu].number=0;
  }

  defsubs(&noclust,&nostruc,tcn,cl,ss);



/* rationalise memory allocation based on ACTUAL number of clusters */

  for(mu=1;mu<MAXcno+1;++mu){
    if(cl[mu].number>0){
      cl[mu].order = (int*) realloc(cl[mu].order,sizeof(int)*(cl[mu].number+1));
    }else{
      cl[mu].order = (int*) realloc(cl[mu].order,sizeof(int)*(1));
    }
  }
  for(mu=noclust+2;mu<MAXcno+1;++mu){
    free((char*)cl[mu].order);
  }
  cl= (struct indclust*) realloc(cl,sizeof(struct indclust)*(noclust+2));

/* rationalise memory allocation based on ACTUAL number of structure groups */

  if(nostruc!=0){
    for(mu=1;mu<MAXcno+1;++mu){
      if(ss[mu].number>0){
        ss[mu].order=(int*)realloc(ss[mu].order,sizeof(int)*(ss[mu].number+1));
      }else{
        ss[mu].order = (int*) realloc(ss[mu].order,sizeof(int)*(1));
      }
    }
    for(mu=nostruc+2;mu<MAXcno+1;++mu){
      free((char*)ss[mu].order);
    }
    ss= (struct indclust*) realloc(ss,sizeof(struct indclust)*(nostruc+2));
  }else{
    for(mu=0;mu<MAXcno+1;++mu){
      free((char*)ss[mu].order);
    }
    free((char*)ss);
  }
  ssno=-1;
  if((edat==1)||(tostr==1)){
    for(mu=0;mu<nbloc+1;++mu)if(strcmp(bloc[nbloc].id,ssid)==0)ssno=mu;
    if(ssno==-1){
      printf("\nError: a 2' structure summary with the");
      printf(" identifier \"%s\" was expected...\n",ssid);
      exit(0);
    }
    printf("Execution: 2' structure summary found in sequence %d...\n",ssno);
  }

/***************************************************************************/
/* Read a property type table in the standatd format into structure ptype  */
/***************************************************************************/

  printf("Execution: reading property table \"%s\"...\n",pfile);
  ptype=readprop(pfile);
  if(neg==0){
    pin=0;point=0;
    for(xx=0;xx<ptype.syno;++xx){
      if((ptype.aas[xx]!=' ')&&
         (ptype.aas[xx]!='X')){
        for(zz=0;zz<ptype.pno;++zz) 
          if(ptype.apm[zz].ptype[xx]==1)pin++;
        if(pin>point)point=pin;
        pin=0;
      }
    }
  } else point=ptype.pno;
  if((consval>point)||(consval<0)){
    printf("\n\nError: stringency >=0 and <=%d for given ptype matrix\n",
           point);
    if(neg==0)
      printf("Maximum mutual properties held with positive conservation: %d\n",
            point);
    exit(0);
  }

/***************************************************************************/
/*         allocate arrays to store conservation returns                   */
/***************************************************************************/

  intcons = (int**) malloc(sizeof(int*)*(noclust+1));
  for(mu=1;mu<noclust+1;++mu){
    intcons[mu] = (int*) malloc(sizeof(int)*(count+2));
    for(mn=0;mn<count+2;++mn) intcons[mu][mn]=-10;
  }
  aa=0;
  if(noclust!=1){for(mn=1;mn<noclust;++mn)aa=aa+mn;}else aa=1;
  same = (int**) malloc(sizeof(int*)*(aa+1));
  for(mn=0;mn<aa+1;++mn){
    same[mn]=(int*) malloc(sizeof(int*)*(count+1));
    for(mu=0;mu<count+1;++mu)same[mn][mu]=-1;
  }
  diff = (int**) malloc(sizeof(int*)*(aa+1));
  for(mn=0;mn<aa+1;++mn){
    diff[mn]=(int*) malloc(sizeof(int*)*(count+1));
    for(mu=0;mu<count+1;++mu)diff[mn][mu]=-1;
  }

/*************************************************************************//*
  calculate conservation value returns
*//*************************************************************************/

  resipos = (struct resisto*) malloc(sizeof(struct resisto) * (count+1));
  for(mn=1;mn<count+1;++mn){
    resipos[mn].resiclust = (char**) malloc (sizeof(char*) * (noclust+1));
    for(mu=0;mu<noclust+1;++mu){
      resipos[mn].resiclust[mu] = (char*) malloc (sizeof(char) * 28);
      for(mx=0;mx<28;++mx)resipos[mn].resiclust[mu][mx]='\0';
    }
  }

  if(noclust>1){
    zcalc(bloc,cl,intcons,same,diff,count,nbloc,ptype,noclust,
           gcut,neg,point,atyp,consval,resipos);
  } else {
    unicalc(bloc,cl,intcons,same,count,nbloc,ptype,
           gcut,neg,point,atyp,consval,resipos);
  }

  printf("Execution: writing output...\n");

/**************************************************************************/
/* Summarise Similarities and differences                                 */
/**************************************************************************/

  printf("           - analysis summary...\n");
  simdif(count,noclust,same,diff,bloc,blocfile,cl,ptype,intcons,
       consval,gcut,idflag,point,atyp,resipos);
  fprintf(stderr,"DEBUG:  back from simdif\n");
  fflush(stderr);
  fflush(stdout);

/**************************************************************************/
/* Produce blocfile for "pretty" plot with similarity/difference data     */
/**************************************************************************/   

   if((pretty==1)||(edat==1)||(tostr==1)||(datout==1)){
     if(pretty==1)printf("           - modified alignment file...\n");
     if(edat==1)printf("           - structure/pattern co-incidence...\n");
     if(tostr==1)printf("           - structure summary...\n");
     if(datout==1)printf("           - conservation pattern...\n");
     if(noclust>1){
       albloc(count,noclust,nostruc,consval,
              aa,same,diff,bloc,blocfile,cl,
              hist,hscale,point,other,datout,
              ss,edat,tostr,ssno,pretty);
     } else onebloc(count,consval,same,bloc,
                    blocfile,cl,hist,hscale,
                    point,other,datout,ss,
                    nostruc,edat,tostr,ssno,pretty,gcut,atyp);
   }
  fprintf(stderr,"DEBUG:  back from albloc/onebloc\n");
  fflush(stderr);
  fflush(stdout);

/**************************************************************************/
/*  Produce alscript code for "pretty" output                             */
/**************************************************************************/
  fprintf(stderr,"DEBUG:  got to interalsc call\n");
  fflush(stderr);
  fflush(stdout);
  if(pretty==1){
    printf("           - alscript copy of analysis...\n");
    interalsc(diff,intcons,bloc,cl,noclust,ptype,count,consval,point,
              def,blocfile,pfile,aa,ps,shade,color,neg,gcut,hist,hscale,
              port,mask,ss,nostruc,aloff,strcr,atyp,nnote,other);
    printf("Execution: ALSCRIPT processing complete.\n");
  }

/**************************************************************************/
/*  THE END					                          */
/**************************************************************************/

  printf("Execution: AMAS analysis complete.\n");

  free((char *) sbuff);
  free((char *) buff);
  exit(0);
}
