# include "includes.h"

simdif(count,noclust,same,diff,bloc,com,cl,ptype,intcons,consval,
       gcut,idflag,point,rogue,resipos)
int count,noclust,consval,gcut,idflag,point;
int **same,**diff,**intcons,rogue;
char *com;
struct seqdat *bloc;
struct slist ptype;
struct indclust *cl;
struct resisto *resipos;
{ 
  FILE *sim;

  int mn,mu,mox,mix,cx,testtmp;
  int tmp;
  char *simname;


/****************************************************************************//*
    File Header Information is printed...
*//****************************************************************************/

  simname = (char*) malloc(sizeof(char)*(strlen(com)+5));

  strcpy(simname,com);

  strcat(simname,".sum");

  simname[strlen(com)+4] = '\0';


  if((sim=fopen(simname,"w"))==NULL){
    printf("Error: cant open file %s\n",simname);
    exit(0);
  } 

  
  fprintf(sim,"AMAS (Analysis of Multiply Aligned Sequences)\n\n");
  fprintf(sim," Version 1.0  - 30th June 1992\n");
  fprintf(sim," Version 1.1  -  3rd July 1992\n");
  fprintf(sim," Version 1.2  - 29th July 1992\n");
  fprintf(sim," Version 1.3  - 27th Oct  1992\n");
  fprintf(sim," Version 1.4  - 13th Jan  1993\n");
  fprintf(sim," Version 1.5  - 10th Feb  1993\n\n");
  fprintf(sim," Version 1.6  -  1st Apr  1993\n\n");
  fprintf(sim," Version 1.65 - 21st Sept 1994\n");
  fprintf(sim," Version 1.66 -  1st May  1995\n\n");
  fprintf(sim," Version 1.67 - 24th May  1995\n\n");
  fprintf(sim," Version 1.67b- 18th Aug  2000\n\n");
  fprintf(sim," See README for instructions      \n\n");
  fprintf(sim," C.D.Livingstone & G.J.Barton     \n");
  fprintf(sim," Copyright (c) C.D.Livingstone & G. J. Barton, 1992\n\n");

  fprintf(sim,"AMAS Conservation Summary\n"); 
  fprintf(sim,"#########################\n\n");
  fprintf(sim,"Conservation Threshold: %3d (Maximum: %3d)\n",consval,point+1);
  fprintf(sim,"Number of gaps ignored: %3d\n",gcut);
  fprintf(sim,"Minimum residue occupancy: %3d%%\n\n",rogue);

/* Identify clusters and identifiers if requested */

  for(mn=1;mn<noclust+1;++mn){
    if(mn<27){fprintf(sim,"Sub-group %c, sequences:  ",mn+64);} 
    else { fprintf(sim,"Sub-group %d, sequences:  ",mn-26);}
    for(mu=1;mu<cl[mn].number+1;++mu){
      if(mu % 20 == 0) fprintf(sim,"\n                       "); 
      tmp=cl[mn].order[mu];
      fprintf(sim,"%3d",cl[mn].order[mu]);

      tmp=0;mix=0;
      for(mox=mu+1;mox<cl[mn].number+1;++mox){
        if((cl[mn].order[mox-1]==cl[mn].order[mox]-1)&&(tmp==0)){
          mix++;
        } else { tmp=1;}
      }
 
      if(mix>3){
        fprintf(sim," to %d",cl[mn].order[mix+mu]);
        mu=mix+mu;
      }
      if(mu<cl[mn].number)fprintf(sim,",");
    }
    fprintf(sim,"\n");
    if(idflag==1){
      fprintf(sim,"\n                       ");
      for(mu=1;mu<cl[mn].number+1;++mu){
        fprintf(sim,"%8s",bloc[cl[mn].order[mu]].id);
        if((mu%4==0)&&(mu<cl[mn].number)){
          fprintf(sim,"\n                       ");
        }else if(mu<cl[mn].number){
          fprintf(sim,"  -  ");
        }else fprintf(sim,"\n\n");
      }
    }
  }
  fprintf(sim,"\n\n\n\n");
  /*  fclose(sim);*/

/****************************************************************************//*
    Report Identities ...
*//****************************************************************************/

  if(noclust>1)idents(bloc,cl,intcons,same,noclust,count,point,simname);

/****************************************************************************//*
    Report Conserved Positions ...
*//****************************************************************************/

  if(noclust>1)consrep(noclust,count,same,diff,point,ptype,
          cl,bloc,simname,intcons,consval,resipos);

/****************************************************************************//*
    Report Unconserved Positions ...
*//****************************************************************************/

  if(noclust>1)ucrep(noclust,count,intcons,consval,cl,ptype,bloc,simname);

/****************************************************************************//*
    Report whole alignment data...
*//****************************************************************************/

  if(noclust==1)ncrep(bloc,cl,count,noclust,intcons,consval,
                      point,ptype,resipos,simname);

/****************************************************************************//*
    End ...
*//****************************************************************************/

  fclose(sim);
  free((char*) simname);

  fprintf(stderr,"DEBUG: about to return from simdif.c\n");
  fflush(stderr);


 
}




