C***************************************************************
      SUBROUTINE Altree(M,N,LOCA,LOCB,KPOS)
C--------------------------------------------------------------
C This subroutine uses the pointer array LOC(*,*) to align the
C current sequence with those already aligned
C
C This version allows the alignmetn of two arbitrary groups of 
C sequences defined by the arrays aclust(nca) and bclust(ncb)
C See routines SCORE, TMULT, RETREE
C
C
C Author: G.J.Barton, Copyright 1985 all rights reserved.
C
C M           length of already aligned sequences
C N           length of sequence to align now
C LOCA        pointer to starting point(=0) if not in column 1
C LOCB        pointer to starting point(=0) if not in row 1
C KPOS        length of sequences after alignment
C IBSEQ       index of seqence to align this time
C IFIN        number of sequences already aligned
C
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'matloc.blk'
C
      integer m,n,loca,locb,kpos
C
      integer IOLD,JOLD,INEXT,JNEXT,
     -        IDIFF,JDIFF,IJ,IZ,IBSEQ,IFIN,IVAL
      
C-----------------------------------------------------------------------
      integer nca,ncb
C     number of sequences in cluster a and cluster b currently aligning
C
      integer aclust(maxseq),bclust(maxseq)
C     arrays holding info on the sequences in each current cluster
C
C --  
      common /itrees/nca,ncb,aclust,bclust

      iold = 0
      jold = 0
      inext = 0
      jnext = 0
      idiff = 0
      ij = 0
      iz = 0
      ibseq = 0
      ifin = 0
      ival = 0
      
C---------------------------------------------------------------
C      IOLD,JOLD = THE COORDS OF THE LAST ARRAY ELEMENT OF LOC
C      INEXT,JNEXT = THE COORDS OF THE NEXT/CURRENT ELEMNT LOC
C---------------------------------------------------------------
      IOLD=0
      JOLD=0
      KPOS=0
C---------------------------------------------------------------
C      LOCATE FIRST ELEMENT OF MAX MATCH USING LOCA,LOCB
C---------------------------------------------------------------
      IF(LOCA.EQ.0)THEN
         INEXT=1
         JNEXT=LOCB
      ELSE
         INEXT=LOCA
         JNEXT=1
      END IF
C---------------------------------------------------------------
C      CALCULATE DIFFERENCE IN I AND J INDICIES WHEN PROCEEDING
C      FROM IOLD,JOLD TO INEXT,JNEXT
C---------------------------------------------------------------
1000  IDIFF=INEXT-IOLD
      JDIFF=JNEXT-JOLD
C---------------------------------------------------------------
C      A VALUE OF IDIFF .GT.1 INDICATES AN INSERT IN SEQA
C      A VALUE OF JDIFF .GT.1 INDICATES AN INSERT IN SEQB
C      IF IDIFF=JDIFF=1 THEN THER IS NO INSERTION
C      KPOS IS THE CURRENT INDEX IN OUTA(KPOS),OUTB
C---------------------------------------------------------------
      IF(IDIFF.GT.1)THEN
         DO 200,IJ=(IOLD+1),INEXT
            KPOS=KPOS+1
C --        cater for the seqa insertion
            do 1,iz=1,nca
               ioutsq(aclust(iz),kpos)=iseq(aclust(iz),ij)
1           continue
            do 111, iz=1,ncb
               ioutsq(bclust(iz),kpos)=0
111         continue
            IF(IJ.EQ.INEXT)THEN
              do 112,iz=1,ncb
                 ioutsq(bclust(iz),kpos)=iseq(bclust(iz),jnext)
112           continue
            END IF
200         CONTINUE
      ELSE IF(JDIFF.GT.1)THEN
C --     cater for the seqb insertion
         DO 300,IJ=(JOLD+1),JNEXT
            KPOS=KPOS+1
            do 113,iz=1,ncb
               ioutsq(bclust(iz),kpos)=iseq(bclust(iz),ij)
113         continue
            do 2,iz=1,nca
               ioutsq(aclust(iz),kpos)=0
2           continue
            IF(IJ.EQ.JNEXT)THEN
              do 3,iz=1,nca
                 ioutsq(aclust(iz),kpos)=iseq(aclust(iz),inext)
3             continue
            END IF
300         CONTINUE
      ELSE
C --     substitution case
         KPOS=KPOS+1
         do 4,iz=1,nca
            ioutsq(aclust(iz),kpos)=iseq(aclust(iz),inext)
4        continue
         do 404,iz=1,ncb
            ioutsq(bclust(iz),kpos)=iseq(bclust(iz),jnext)
404      continue
      END IF
C---------------------------------------------------------------
C      UPDATE IOLD,JOLD
C      THEN INTERROGATE LOC(IOLD,JOLD) TO DISCOVER THE VALUES
C      OF NEXTI,NEXTJ
C      A VALUE OF LOC( , ) GT THOU INDICATES AN INSERTION IN
C      SEQB
C      THIS IS JUST A CONVENIENT WAY OF CODING THE TYPE OF
C      INSERTION SEQA OR SEQB
C      SEE SUBROUTINE RECURS FOR DETAILS OF LOC CREATION
C--------------------------------------------------------------
      IOLD=INEXT
      JOLD=JNEXT
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE  IE IOLD=M-1,OR JOLD=N-1
C---------------------------------------------------------------
      IF(IOLD.EQ.(M).OR.JOLD.EQ.(N))THEN
      ELSE
          IVAL=LOC(IOLD,JOLD)
          IF(IVAL.GT.THOU)THEN
             INEXT=IOLD+1
             JNEXT=IVAL-THOU
          ELSE
             INEXT=IVAL
             JNEXT=JOLD+1
          END IF
          GO TO 1000
      END IF
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE AND INSERT BLANKS IN THE
C      APPROPRIATE OUT(A/B) ARRAY
C---------------------------------------------------------------
      IF((IOLD.EQ.M).AND.(JOLD.EQ.N))THEN
         do 5,iz=1,nca
            ioutsq(aclust(iz),kpos)=iseq(aclust(iz),M)
5        continue
         do 505,iz=1,ncb
            ioutsq(bclust(iz),kpos)=iseq(bclust(iz),n)
505      continue
         RETURN
      ELSE IF(IOLD.EQ.M)THEN
         DO 400,IJ=JNEXT+1,N
            KPOS=KPOS+1
            do 6,iz=1,nca
               ioutsq(aclust(iz),kpos) = 0
6           continue
            do 606,iz=1,ncb
               ioutsq(bclust(iz),kpos) = iseq(bclust(iz),ij)
606         continue
400      CONTINUE
         RETURN
      ELSE IF(JOLD.EQ.N)THEN
         DO 500,IJ=INEXT+1,M
            KPOS=KPOS+1
            do 7,iz=1,nca
               ioutsq(aclust(iz),kpos)=iseq(aclust(iz),ij)
7           continue
            do 707,iz=1,ncb
               ioutsq(bclust(iz),kpos)=0
707         continue
500      CONTINUE
         RETURN
      END IF
      END
C---------------------------------------------------------------


