C************************************************************
      SUBROUTINE GCHECK(IBSEQ,KPOS,IERR)
C------------------------------------------------------------
C Subroutine to perform various checks on the aligned sequences
C
C  put all of sequence except template into lower case
C  do checking of all pairs of sequences for accuracy
C
C Author: G. J. Barton (1985)
C
C-------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'gapmis.blk'
      include 'tester.blk'
C
      INTEGER I,J,KK,IBSEQ,KPOS,IERR
C
C --  put everything into lower case letters
      DO 10,I=1,IBSEQ
         DO 10,J=1,KPOS
            CALL CLCASE(SEQ(J,I))
10    CONTINUE
C
C --  sort out which template region refers to which seq
C     store result in pointer array TEMPT
      DO 20,I=1,IBSEQ
         DO 30,J=1,IBSEQ
            IF(INDEX(TIDENT(J),IDENTS(I)).GT.0)THEN
              TEMPT(I) = J
            END IF
30       CONTINUE
C      write(6,*)'idents(i) ',idents(i),' tident(tempt(i)) ',
C     -           tident(tempt(i))
20    CONTINUE
C --
C      do 535,i=1,ibseq
C        write(6,600)idents(i),(seq(j,i),j=1,kpos)
C        write(6,601)(iseq(i,j),j=1,kpos)
C535   continue
C600   format(//1x,a10,1x,40a3)
C601   format(11x,40i3)
C --
C
C --  set relevant bits of sequences to uppercase
      DO 40,I=1,IBSEQ
C        set up aplate based on current sequence
         CALL PLATE(I,1,KPOS)
         DO 33,KK=1,KPOS
            IF(PLATEs(KK,1).GT.0)THEN
              CALL CUCASE(SEQ(KK,I))
            END IF
33       CONTINUE
         DO 50,J=I,IBSEQ
C           set up bplate on current seq
            CALL PLATE(J,2,KPOS)
C
C --        see how good the alignment is
C
C
C         write(6,666)idents(i)
C         write(6,667)(plates(kk,1),kk=1,kpos)
C         write(6,666)idents(j)
C         write(6,667)(plates(kk,2),kk=1,kpos)
C666      format(1x,a10,1x,40i3)
C667      format(12x,40i3)
C
C
            TSCORE(J,I)=0.0
            DO 60,KK=1,KPOS
               IF(PLATEs(KK,1).GT.0.AND.PLATEs(KK,2).GT.0)THEN
                  IF(PLATES(KK,1).EQ.PLATES(KK,2))THEN
                    TSCORE(J,I)=TSCORE(J,I)+1.0
                  END IF
               END IF
60          CONTINUE
50       CONTINUE
40    CONTINUE
C
C --
      END



