C**************************************************************
      SUBROUTINE MLOOK4(IBSEQ,IFIN,IDIV,KPOS)
C--------------------------------------------------------------
C Subroutine to make a look up table for subsequent reference by
C RECALL
C
C This version uses Marketas conservation system to calculate
C a conservation value for each amino acid versus the
C current alignment
C NOTE:  this routine has the same data statement as routine
C        MZCONS.  This could be put into common
C
C Author: G. J. Barton
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'dayhof.blk'
      include 'param2.blk'
      include 'probas.blk'
      include 'conser.blk'
C
      integer ibseq,ifin,idiv,kpos
C
C --
      INTEGER II
      REAL TEMP,PR

C
C --  conmat contains a table like that shown in the JMB paper
C     order of amino acids is GAP,ARNDCQEGHILKMFPSTWYBZX
      INTEGER CONMAT(10,0:23),CONCNT,IT,I,J,K,L,TCNT
      INTEGER NIDE, FACID
      DATA CONMAT/1,1,1,1,1,1,1,1,1,1, 1,0,0,0,0,1,1,0,0,0,
     -            0,1,0,1,1,0,0,0,0,0, 0,0,0,1,0,1,0,0,0,0,
     -            0,0,1,1,1,1,0,0,0,0, 1,0,0,0,0,1,0,0,0,0,
     -            0,0,0,1,0,0,0,0,0,0, 0,0,1,1,1,0,0,0,0,0,
     -            1,0,0,0,0,1,1,0,0,0, 1,1,0,1,1,0,0,0,1,0,
     -            1,0,0,0,0,0,0,1,0,0, 1,0,0,0,0,0,0,1,0,0,
     -            1,1,0,1,1,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0,
     -            1,0,0,0,0,0,0,0,1,0, 0,0,0,0,0,1,0,0,0,1,
     -            0,0,0,1,0,1,1,0,0,0, 1,0,0,1,0,1,0,0,0,0,
     -            1,0,0,1,0,0,0,0,1,0, 1,0,0,1,0,0,0,0,1,0,
     -            1,0,0,0,0,1,0,1,0,0, 0,0,0,1,0,0,0,0,0,0,
     -            0,0,0,1,0,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1/
      concnt = 0
      it = 0
      i = 0
      j = 0
      k = 0
      l = 0
      nide = 0
      facid = 0
      temp = 0.0
      pr = 0.0
C
C --  loop over each amino acid type
      DO 100,II=0,23
C
C --  loop over length of alignment
      DO 10,I=1,KPOS
C --     initialise the current counter to 0
         CONCNT = 0
C --     loop over aligned positions increment concnt
C        when something different to the first assignment is
C        found: outer loop over properties
         DO 20,J=1,10
C          set IT to the value of the first amino acid
           IT = CONMAT(J,II)
C          loop over remaining acids, if a difference occurs then
C          set tcnt to 1
           TCNT = 0
           DO 30,K=1,IFIN
              IF(K.EQ.IBSEQ)GOTO 30
              IF(IT.NE.CONMAT(J,ISEQ(K,I)))THEN
                TCNT = 1
              END IF
30         CONTINUE
C          add tcnt to concnt
           CONCNT = CONCNT + TCNT
20       CONTINUE
C
C --     check for total identity at this position
         FACID = II
         NIDE = 0
         DO 33,K=1,IFIN
            IF(IBSEQ.EQ.K)GOTO 33
            IF(FACID.EQ.ISEQ(K,I))THEN
               NIDE = NIDE +1
            END IF
33       CONTINUE
C
C --     calculate the conservation
         IF(CONCNT.EQ.10)THEN
            LOOKUP(I,II) = 0.0
         ELSE IF(CONCNT.EQ.0)THEN
            IF(NIDE.EQ.IBSEQ-1)THEN
C             total identity
              LOOKUP(I,II) = 10.0
            ELSE
C             not identity, but same properties
              LOOKUP(I,II) = 9.0
            END IF
         ELSE
           LOOKUP(I,II) = (0.9 - 0.1 * CONCNT)*10.0
         END IF
10    CONTINUE
100   CONTINUE
C
      END
C

