C************************************************************
      subroutine multd
C------------------------------------------------------------
C Subroutine to allow the sequences defined in PSFILE to be 
C compared pairwise with the sequences in the DATABASE file
C
C Geoff Barton 30/9/1988
C
C Influences:  prmin,prmax,princ min max and increment for
C              performing randomisations.
C
C------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
      include 'speedo.blk'
C

      INTEGER   ALOC,BLOC,
     -          I,J,KPOS,LJMIN,LIMAX,limin
      INTEGER      NGAPS,NALIG,NIDENT,K

      INTEGER*4    JSEED,npos

      REAL         PIDENT,NAS,NASAL,STDEV,RSCORE
      INTEGER      iin
C
      logical eof,error
C
C --
      iin = 1
      limin = 1
C
C -- this routine is cribbed from multc..  so set i and j
C    to 1 and 2
C
      i = 1
      j = 2
      inumb = 2
C
C--   do the pairwise alignments
C
C --define the number of random runs to be prmin
C   multiple random run values are thus ignored
C
      nrans = prmin
C
C --start point for reading next PSFILE sequence
C
      error = .false.
7000  continue
      eof = .false.
      call fseqmf(isq,iout,eof,error,.true.,'    ',
     -seq(1,1),maxdim,numb(1),idents(1),names(1))
C
C --if error abort
      if(error)then
         call amess(ierr,1,'Error reading PSFILE seq',1,'e')
         stop
      end if
C
C --all done so quit cleanly
      if(eof)then
         write(iout,7771)
7771     format(1x,'#/#/#')
         stop
      end if
C
      rewind(idbase)
      write(iout,7123)idents(1)
C --  10/9/91 - change a10 to a20 to reflect change in idents from 10 to 20
7123  format(1x,'###',1x,a20)
C
C --start point for reading next DATABASE file sequence
C
7001  continue
      call fseqmf(idbase,iout,eof,error,.true.,'    ',
     -seq(1,2),maxdim,numb(2),idents(2),names(2))
C
      if(error)then
        call amess(ierr,1,'Error reading dbase file',1,'e')
        stop
      end if
C
C -- end of file so back for next psfile seq
C
      if(eof)then
         goto 7000
      end if
C
C --check this seq is long enough to bother with
      if(comnd(44))then
         if(numb(2).lt.mindbl)then
            goto 7001
         end if
      end if
C
C --convert seqs to integer
C
      call koncom(inumb)
C
C --do the pairwise stuff
C
C     a) extract the two integer sequences we are going
C        to align this time
C        write(ierr,*)'calling extseq'
         CALL EXTSEQ(I,J)
C
C     b) align jaseq and jbseq,find internal gaps,
C        aligned positions, number of identities,
         if(comnd(46))then
            call recpf(NUMB(I),NUMB(J),GAP,MATCH,ALOC,BLOC)
         else
            CALL RECP(NUMB(I),NUMB(J),GAP,MATCH,ALOC,BLOC)
         end if
         CALL ALIGN(NUMB(I),NUMB(J),ALOC,BLOC,KPOS)
         CALL INFO(NGAPS,NALIG,NIDENT,KPOS)
C
C        c) calculate and store the %identity and NAS
         PIDENT = (FLOAT(NIDENT)/FLOAT(NALIG))*100.0
         NAS    = (MATCH/NALIG)*100.0
         NASAL  = ((MATCH-(NGAPS*GAP))/NALIG)*100.0
C
C --     chuck it out if .lt. PID cutoff
         if(comnd(45))then
            if(pident.lt.float(pidcut))then
               goto 7001
            end if
         end if

C
         IF(NRANS.GT.0)THEN
C        d) do the NRANS random runs
            JSEED =-3121597
            DO 1111,K=1,NRANS
               CALL SCRAM(jaseq,NUMB(I),JSEED)
C
               CALL SCRAM(jbseq,NUMB(J),JSEED)
C
               if(comnd(46))then
               call recpfn(NUMB(I),NUMB(J),GAP,RMATCH(K),
     -              ALOC,BLOC)
               else
               CALL RECP(NUMB(I),NUMB(J),GAP,RMATCH(K),
     -              ALOC,BLOC)
               end if
1111        CONTINUE
C
C        e) do stats on random runs
            CALL STATS(RMATCH,NRANS,RMEAN,STDEV)
            RSCORE = (MATCH-RMEAN)/STDEV
         END IF
C
C        f) write out the details for this pair
            IF(comnd(9).or.comnd(10))THEN
              CALL KONB2(KPOS)
              CALL PRET2(I,J,KPOS)
            END IF
            write(iout,6000)idents(2),MATCH,
     -                   NGAPS,NALIG,NIDENT,pident,nas,nasal

C
C -- back for the next database sequence
C
      goto 7001
C
C
6000  FORMAT(1X,a20,F10.2,3I7,3f10.2)
C
      END
C


