C*********************************************************************
      real function score(idiv,ip,jp)
C---------------------------------------------------------------------
C Calcluates the mean score over all pairs of comparisons between the
C sequences identified in aclust(nca) bclust(ncb) at the sequence position
C ip,jp.  idiv is the number
C of comparisons that are made - simply the top half of an nca * ncb 
C matrix (nca*(ncb-1)/2).
C
C This routine is designed to be called specifically by the routine 
C retree.
C
C G. J. Barton 1987
C---------------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'dayhof.blk'
C common variables peculiar to this tmult.f

      integer nca,ncb
C     number of sequences in cluster a and cluster b currently aligning
C
      integer aclust(maxseq),bclust(maxseq)
C     arrays holding info on the sequences in each current cluster
C
C --  
      common /itrees/nca,ncb,aclust,bclust
C-----------------------------------------------------------------------
C
      integer idiv,ip,jp,i,j

      score = 0.0
      do 10,i=1,nca
         do 10,j=1,ncb
            score = score + day(iseq(bclust(j),jp),iseq(aclust(i),ip))
10    continue
C
      score = score/idiv
C
      end
C
