C*******************************************************************
      subroutine gjplot(simmat,n,nentry,ident)
C-------------------------------------------------------------------
C   Version adapted to produce PostScript output  14/2/1992
C
C subroutine to plot dendrograms (called from CLUST)
C This routine uses SIMPLEPLOT Calls
C
C Note, there are undoubtedly redundant variables passed in common
C to this routine.  This is the result of splitting a larger program
C-------------------------------------------------------------------
      implicit undefined(a-z)
C
C include file of virtually everything
C
      include 'clust.blk'
      real xr,yr,ymin,xfac,yfac

C
C --------------------------------------------------------------
C this section could be proceduralised as it is solely concerned
C with plotting th result of the cluster analysis by using
C the Simpleplot routines
C---------------------------------------------------------------
C
C --  ask nicely for the title and xaxis title and text mag
      CALL QMESS(6,5,1,'Please enter the axis title :',xtit)
      CALL QMESS(6,5,1,'Please enter the plot title :',tit)
      CALL QMESS(6,5,1,'Vertical format ?? (def = horizontal) ',
     -LINE)
      IF(INDEX(LINE,'V').GT.0)THEN
         VERT=.TRUE.
      ELSE
         VERT=.FALSE.
      END IF
C
C      CALL AMESS(6,1,'Enter text mag factor ',1,' ')
C      READ(5,*)TMAG
C --  set page size
C      CALL QMESS(6,5,1,'A3 OR A4 SIZE ? (DEF=A3) ',LINE)
C      IF(INDEX(LINE,'A4').GT.0)THEN
C        CALL PAGE(25.0,18.0)
C      ELSE
C        CALL PAGE(42.0,29.0)
C      END IF
C
      DIVIT = 10.0
      XRANGE = CSCORE(1)-CSCORE(NCLUST)
C
C --  scale the plot so that min x is a bit less than
C     the min value to be plotted, and max x is a bit more
C     than the max value to be plotted.  Ymin = 0 and y max
C     is the number of entries +1
      ABIT = XRANGE/DIVIT
      XMAX = CSCORE(1)+2.0*ABIT
C
C
      IF(VERT)THEN
         xfac = 10.0 * 72
	 xr = float(nentry)+1.0
	 yr = xmax - (cscore(nclust) - abit)
         xmin = -1.0
	 ymin = (cscore(nclust) - abit)
C        CALL SCALES(-1.0,FLOAT(NENTRY),1,
C     -              CSCORE(NCLUST)-ABIT,
C     -              XMAX,1)
       ELSE
         xfac = 6.0 * 72
         xr = (xmax + abit/2.0) - (cscore(nclust) - xrange/divit)
         yr = float(nentry)+1
	 xmin = (cscore(nclust) - xrange/divit)
	 ymin = 0.0
C        CALL SCALES(CSCORE(NCLUST)-XRANGE/DIVIT,
C     -              XMAX+ABIT/2.0,1,
C     -              0.0,FLOAT(NENTRY)+1.0,1)
       END IF
C
C --
C      CALL NEWPIC
C
C --  set up and draw Xaxis ( no yaxis is required)
C      IF(VERT)THEN
C         CALL TEXTMG(TMAG)
C         CALL YAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C         CALL TEXTMG(1.0)
C      ELSE
C         CALL XAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C      END IF
C
C --  Set up a pointer array to the positions of elements to
C     be plotted
      DO 91,I=1,NCTOT(NCLUST)
         POINT(CTOTAL(NCLUST,I)) = I
91    CONTINUE
C
C --  write the identifying numbers down the rhs of plot
C     or across the top if vert=.t.
C      CALL TEXTMG(TMAG)
C Set the font
      write(7,9991)15
9991  format(1x,'/Times-Roman findfont ',i5,' scalefont setfont')

      IF(VERT)THEN
C         CALL LABJST('B','R')
         BBIT=ABIT/5.0
         MBIT=0
         DO 97,I=1,NCTOT(NCLUST)
            MBIT=MBIT+1
            IF(MBIT.EQ.6)MBIT=1
	    
C            CALL CP7LB(FLOAT(I),CSCORE(1)+ABIT+MBIT*BBIT,
C     -      INCHAR(CTOTAL(NCLUST,I)))
97       CONTINUE
      ELSE
         DO 92,I=1,NCTOT(NCLUST)
	    write(7,9992)
     - ((cscore(1)+abit-xmin)/xr)*xfac,
     - ((float(i)-ymin)/yr)*yfac,
     -      ctotal(nclust,i),
     -      ident(ctotal(nclust,i))

9992        format(1x,2f8.2,' moveto (',i7,' ',a,') show')
C
C            CALL CP7LB(cscore(1)+ABIT,FLOAT(I),
C     -      INCHAR(CTOTAL(NCLUST,I))//' '//
C     -      ident(CTOTAL(NCLUST,I)))
92       CONTINUE
      END IF
C      CALL TEXTMG(1.0)
C
C --  start drawing the cluster diagram by going down the list
C     stored in CPAIRS
      DO 93,I=1,NCLUST
C        if we are joining a cluster then find the mean Y position
C        otherwise set the value to the y position of the element
C        do the first of the pair
         IF(CPAIRS(1,I).GT.CADD)THEN
            TINDEX = CPAIRS(1,I)-CADD
            TOT = 0.0
            DO 94,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
94          CONTINUE
            Y(1) = TOT/NCTOT(TINDEX)
            X(1) = CSCORE(TINDEX)
            X(2) = CSCORE(I)
         ELSE
            Y(1) = POINT(cpairs(1,i))
            X(1) = CSCORE(1)+ABIT
            X(2) = CSCORE(I)
         END IF
C
C --     do the second of the pair
         IF(CPAIRS(2,I).GT.CADD)THEN
            TINDEX = CPAIRS(2,I)-CADD
            TOT = 0.0
            DO 95,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
95          CONTINUE
            Y(4) = TOT/NCTOT(TINDEX)
            X(4) = CSCORE(TINDEX)
          ELSE
            Y(4) = POINT(cpairs(2,i))
            X(4) = CSCORE(1)+ABIT
          END IF
C
C --      now call jclust to join the points up
          CALL JCLUST(X,Y,4,VERT,
     -     xmin,ymin,xfac,yfac,xr,yr)
93    CONTINUE
C
C --
C      CALL TITLE7('H','C',TIT(1:ENDFIN(TIT)))
C
C --
C      CALL ENDPLT
       write(7,9995)
9995   format(' stroke'/' showpage')
C
      END
C
C**************************************************************
      SUBROUTINE JCLUST(X,Y,N,VERT,xmin,ymin,
     -                  xfac,yfac,xr,yr)
C--------------------------------------------------------------
      implicit undefined(a-z)
C
      INTEGER I,N
      REAL X(N),Y(N),XV(4),YV(4),xmin,ymin,xfac,yfac
      real xr,yr
      LOGICAL VERT
C
      Y(2) = Y(1)
      Y(3) = Y(4)
      X(3) = X(2)
C
      IF(VERT)THEN
        XV(1)=Y(4)
        YV(1)=X(4)
        XV(2)=Y(3)
        YV(2)=X(3)
        XV(3)=Y(2)
        YV(3)=X(2)
        XV(4)=Y(1)
        YV(4)=X(1)
      END IF
C
      IF(VERT)THEN
	write(7,9996)xv(1),yv(1)
9996    format(1x,2f8.2,' stroke moveto')
        DO 11,I=1,N
C           CALL JOIN PT(XV(I),YV(I))
	    write(7,9997)((xv(i)-xmin)/xr)*xfac,
     -                   ((yv(i)-ymin)/yr)*yfac
9997        format(2f8.2,' lineto')
11      CONTINUE
      ELSE
	write(7,9996)x(1),y(1)
        DO 10,I=1,N
C           CALL JOIN PT(X(I),Y(I))
	    write(7,9997)((x(i)-xmin)/xr)*xfac,
     -                   ((y(i)-ymin)/yr)*yfac
10      CONTINUE
      END IF

C
C      CALL BREAK
C

      END
