C***************************************************************
      SUBROUTINE FBLOC(IIN,NSEQ,TOTSEQ,ITNO)
C---------------------------------------------------------------
C G. J. BARTON 1987
C
C Routine to read in an alignment from a file in the format
C generated by the PRINT_VERTICAL command.  The seqences
C are stored as normal.. see FSEQCF for details.
C
C In addition, this routine reads gap-bias regions from the
C block file.  ie sequence postion 0 stores the characters
C ' ' for a normal residue
C '<' for the beginning of a range to have a lowered penalty
C '#' for the end of a range
C This characters must be inserted in the block file after
C the aligned sequences
C
C This routine also allows patterns to be read in a similar
C format eg
C AAAGV <0:10
C PPPPG
C WWEFF <2:2  definition of allowed gap lengths
C
C This version calculates the min allowed pattern length
C
C IIN    = INPUT CHANNEL
C IOUT   = OUTPUT CHANNEL (ERRORS AND ALL)
C NSEQ   = NUMBER OF SEQUENCES BEFORE THIS ROUTINE WAS CALLED
C TOTSEQ = NUMBER OF SEQUENCES AFTER THE ROUTINE CALLED
C ITNO   = THE ITERATION NUMBER WHICH WILL BE READ
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'seqcha.blk'
      include 'intseq.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
C     flag to indicate the end of the identifier fields
      LOGICAL FIDENT,SIDENT
      CHARACTER*132 BUFF,INCHAR*1
C
      INTEGER IOS,TOTSEQ,NSEQ,ILOCS,ITNO,I,J,K,IIN,ENDFIN
C
      SIDENT=.TRUE.
      FIDENT=.FALSE.
      IOS = 0
      TOTSEQ=NSEQ
C
C --  read file IIN and store any IDENTS and titles found found
1     CONTINUE
      CALL SCHAR(1,BUFF)
      READ(IIN,100,IOSTAT=IOS)BUFF
      if(ios.ne.0)then
        call amess(ierr,1,'Premature end of BLOCK FILE',
     -  1,'e')
        call amess(ierr,0,
     -  'Check that the iteration number is correctly '//
     -  'defined in the block_file command',1,'e')
         stop
      end if
100   FORMAT(A)
      ILOCS = INDEX(BUFF,'>')
      IF(ILOCS.GT.0)THEN
        SIDENT=.TRUE.
        TOTSEQ=TOTSEQ+1
C --    10/9/91 change to 19 and 20 to reflect increase in IDENTS length
        IDENTS(TOTSEQ)=BUFF(ILOCS:ILOCS+19)
        NAMES(TOTSEQ)=BUFF(ILOCS+20:)
        GOTO 1
      ELSE IF(SIDENT)THEN
C
C --    find the * ITERATION then read the sequence lines
        IF((INDEX(BUFF,'*').GT.0).AND.
     -    (INDEX(BUFF,INCHAR(ITNO)).GT.0))THEN
          ILOCS=INDEX(BUFF,'*')
          I=0

C         read the sequence lines until another star is encountered
2         CONTINUE
          CALL SCHAR(1,BUFF)
          READ(IIN,100,IOSTAT=IOS)BUFF
          IF(IOS.NE.0)THEN
            CALL AMESS(IOUT,1,'ERROR READING SEQUENCE LINES',1,'E')
            STOP
          END IF
          IF(INDEX(BUFF,'*').GT.0)THEN
            CALL AMESS(IOUT,1,'ALIGNMENT READ ',1,'-')
C --        calculate min pattern length
            IF(COMND(29))THEN
              DO 67,I=1,NUMB(1)
                MINPAT=MINPAT+1+GAPMIN(I)
67            CONTINUE
            END IF
            RETURN
          END IF
          K=NSEQ
          I=I+1
C
C --      check if max pattern length exceeded!!
          IF(I.GT.MAXPAT)THEN
             CALL AMESS(IOUT,1,'Error: maximum pattern length exceeded',
     -       1,'e')
             STOP
          END IF
C
C --      check for presence of < or # if present the store in seq(0)
          IF((INDEX(BUFF,'<')).GT.0)THEN
            SEQ(I,0)='<'
            IF(COMND(20))THEN
C             we are reading a pattern file so decode gap info
              CALL DEFGAP(BUFF(INDEX(BUFF,'<'):),GAPMIN(I),GAPMAX(I))
C              write(6,*)buff,gapmin(i),gapmax(i)
            END IF
          ELSE IF((INDEX(BUFF,'#')).GT.0)THEN
            SEQ(I,0)='#'
          ELSE
            SEQ(I,0)=' '
            GAPMIN(I)=0
            GAPMAX(I)=0
          END IF
C --      if this is a pattern file then echo the pattern to the
C         output file
          IF(COMND(20))THEN
            CALL AMESS(IOUT,0,BUFF(1:ENDFIN(BUFF)),0,' ')
          END IF
C
          DO 10,J=ILOCS,(ilocs+totseq-1)
             K=K+1
             if(.not.comnd(210))call cucase(buff(j:j))
             SEQ(I,K)=BUFF(J:J)
             NUMB(K)=I
10        CONTINUE
          GOTO 2
        END IF
        GOTO 1
      END IF
      GOTO 1
C
      END
C
C*****************************************************************
      SUBROUTINE DEFGAP(LINE,GMIN,GMAX)
C-----------------------------------------------------------------
C Given line, returns gmin and gmax
C if no colon or any error at all gmin and gmax are returned
C as zero
C-----------------------------------------------------------------
C
      CHARACTER*(*) LINE
      INTEGER GMIN,GMAX,LCOL
      LOGICAL ERROR
C
      ERROR = .FALSE.
      GMIN=0
      GMAX=0
      LCOL=INDEX(LINE,':')
      IF(LCOL.EQ.0)RETURN
C
      CALL INTCOM(LINE(1:LCOL-1),GMIN,ERROR)
      IF(ERROR)THEN
        GMIN = 0
        RETURN
      END IF
C
      CALL INTCOM(LINE(LCOL+1:),GMAX,ERROR)
      IF(ERROR)THEN
        GMAX=0
        RETURN
      END IF
C
      END
C


