C************************************************************
      subroutine multc
C------------------------------------------------------------
C Author:  G. J. Barton 
C
C subroutine to perform pairwise comparisons on the seqences
C supplied.
C Influences:  prmin,prmax,princ min max and increment for
C              performing randomisations.
c comnd(32)    defines that the comparisons will include
C              self comparisons
C
C------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
      include 'speedo.blk'

      INTEGER   ALOC,BLOC,
     -          I,J,KPOS,LJMIN,LIMAX,limin
      INTEGER      NGAPS,NALIG,NIDENT,K

      INTEGER*4    JSEED,npos

      REAL         PIDENT,NAS,NASAL,STDEV,RSCORE
      INTEGER      iin
C
C --
      iin = 1
      limin = 1
      npos = 0
      aloc = 0
      bloc = 0
      kpos = 0
      ljmin = 0
      limax = 0
      ngaps = 0
      nalig = 0
      nident = 0
      k = 0
      jseed = 0
      pident = 0.0
      nas = 0.0
      nasal = 0.0
      stdev = 0.0
      rscore = 0.0
C
C--   do the pairwise alignments
C
      write(iout,5999)
C     loop over the number of sets of random runs required
      do 1200,nrans=prmin,prmax,princ
C
C--   do we want to do self comparisons?
      IF(comnd(32))THEN
         LIMAX = INUMB
      ELSE
         LIMAX = INUMB-1
      END IF
C
C --  get on with the comparisons
      DO 1000,I=LIMIN,LIMAX
         IF(comnd(32))THEN
           LJMIN = I
         ELSE
           LJMIN = I+1
         END If
C
C         if(comnd(31))call lib$init_timer()
C
         if(comnd(31))call timer1(iout)
C
         DO 1000,J=LJMIN,INUMB
         npos = npos+1
C         write(iout,*)'i,j',i,j
C
C        a) extract the two integer sequences we are going
C           to align this time
C        write(ierr,*)'calling extseq'
         CALL EXTSEQ(I,J)
C
C        b) align jaseq and jbseq,find internal gaps,
C           aligned positions, number of identities,
C         write(ierr,*)'calling recp'
C         write(ierr,*)'gap',gap,'match',match,aloc,bloc
C
         if(comnd(46))then
            call recpf(NUMB(I),NUMB(J),GAP,MATCH,ALOC,BLOC)
         else
            CALL RECP(NUMB(I),NUMB(J),GAP,MATCH,ALOC,BLOC)
         end if
C         write(ierr,*)'recp completed'
C
C
C         write(ierr,*)'calling align'
         CALL ALIGN(NUMB(I),NUMB(J),ALOC,BLOC,KPOS)
C         write(ierr,*)'calling info'
         CALL INFO(NGAPS,NALIG,NIDENT,KPOS)
C
C        c) calculate and store the %identity and NAS
         PIDENT = (FLOAT(NIDENT)/FLOAT(NALIG))*100.0
         NAS    = (MATCH/NALIG)*100.0
         NASAL  = ((MATCH-(NGAPS*GAP))/NALIG)*100.0
C
         IF(NRANS.GT.0)THEN
C        d) do the NRANS random runs
            JSEED =-3121597
            DO 1111,K=1,NRANS
               CALL SCRAM(jaseq,NUMB(I),JSEED)
C
               CALL SCRAM(jbseq,NUMB(J),JSEED)
C
               if(comnd(46))then
               call recpfn(NUMB(I),NUMB(J),GAP,RMATCH(K),
     -              ALOC,BLOC)
               else
               CALL RECP(NUMB(I),NUMB(J),GAP,RMATCH(K),
     -              ALOC,BLOC)
               end if
C
C               write(iout,*)'match score for this random run',rmatch(k)
1111        CONTINUE
C
C        e) do stats on random runs
C            write(iout,*)'calling stats'
            CALL STATS(RMATCH,NRANS,RMEAN,STDEV)
            RSCORE = (MATCH-RMEAN)/STDEV
C            write(iout,*)'stats done ','rmatch=',rmatch,
C     -      ' nrans = ',nrans,
C     -                'rmean = ',rmean,' stdev = ',stdev
         END IF
C
C        f) write out the details for this pair
            IF(comnd(9).or.comnd(10))THEN
C              write(iout,*)'calling konbak'
              CALL KONB2(KPOS)
C              write(iout,*)'calling pretty'
              CALL PRET2(I,J,KPOS)
            END IF
C            write(iout,*)'about to write details to file'
            write(iout,6000)I,J,NUMB(I),NUMB(J),MATCH,
     -                   NGAPS,NALIG,NIDENT,PIDENT,NAS,NASAL,
     -                   NRANS,RMEAN,STDEV,
     -                   RSCORE,npos
            IF(comnd(31))CALL timer2(iout)
C
1000  CONTINUE
1200  continue
C
5999  FORMAT(1X,'    I','    J',' ILEN',' JLEN',
     -          '     MATCH','  NGAPS','  NALIG',
     -          ' NIDENT','    %IDENT','       NAS',
     -          '     NASAL',
     -          '  NRANS','     RMEAN','     STDEV',
     -          '     SCORE')
6000  FORMAT(1X,4I5,F10.2,3I7,3F10.2,I7,3F10.2,I7)
C
      END
C


