C******************************************************
      SUBROUTINE MZCONS(KPOS,IBSEQ)
C------------------------------------------------------
C Author:  G. J. Barton
C
C subroutine to calculate conservation at each position
C in the sequence using Marketa's method
C------------------------------------------------------
C
      include 'params.blk'
      include 'dayhof.blk'
      include 'seqcha.blk'
      include 'intseq.blk'
      include 'conser.blk'
C
C --  conmat contains a table like that shown in the JMB paper
C     order of amino acids is GAP,ARNDCQEGHILKMFPSTWYBZX
      INTEGER CONMAT(10,0:23),CONCNT,IT,I,J,K,L,KPOS,TCNT,IBSEQ
      INTEGER NIDE, FACID
      DATA CONMAT/1,1,1,1,1,1,1,1,1,1, 1,0,0,0,0,1,1,0,0,0,
     -            0,1,0,1,1,0,0,0,0,0, 0,0,0,1,0,1,0,0,0,0,
     -            0,0,1,1,1,1,0,0,0,0, 1,0,0,0,0,1,0,0,0,0,
     -            0,0,0,1,0,0,0,0,0,0, 0,0,1,1,1,0,0,0,0,0,
     -            1,0,0,0,0,1,1,0,0,0, 1,1,0,1,1,0,0,0,1,0,
     -            1,0,0,0,0,0,0,1,0,0, 1,0,0,0,0,0,0,1,0,0,
     -            1,1,0,1,1,0,0,0,0,0, 1,0,0,0,0,0,0,0,0,0,
     -            1,0,0,0,0,0,0,0,1,0, 0,0,0,0,0,1,0,0,0,1,
     -            0,0,0,1,0,1,1,0,0,0, 1,0,0,1,0,1,0,0,0,0,
     -            1,0,0,1,0,0,0,0,1,0, 1,0,0,1,0,0,0,0,1,0,
     -            1,0,0,0,0,1,0,1,0,0, 0,0,0,1,0,0,0,0,0,0,
     -            0,0,0,1,0,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1/
C
C --  loop over length of alignment
      DO 10,I=1,KPOS
C --     initialise the current counter to 0
         CONCNT = 0
C --     loop over aligned positions increment concnt
C        when something different to the first assignment is
C        found: outer loop over properties
         DO 20,J=1,10
C          set IT to the value of the first amino acid
           IT = CONMAT(J,IOUTSQ(1,I))
C          loop over remaining acids, if a difference occurs then
C          set tcnt to 1
           TCNT = 0
           DO 30,K=2,IBSEQ
              IF(IT.NE.CONMAT(J,IOUTSQ(K,I)))THEN
                TCNT = 1
              END IF
30         CONTINUE
C          add tcnt to concnt
           CONCNT = CONCNT + TCNT
20       CONTINUE
C
C --     check for total identity at this position
         FACID = IOUTSQ(1,I)
         NIDE = 0
         DO 33,K=2,IBSEQ
            IF(FACID.EQ.IOUTSQ(K,I))THEN
               NIDE = NIDE +1
            END IF
33       CONTINUE
C
C --     calculate the conservation
         IF(CONCNT.EQ.10)THEN
            CON(I) = 0.0
         ELSE IF(CONCNT.EQ.0)THEN
            IF(NIDE.EQ.IBSEQ-1)THEN
C             total identity
              CON(I) = 1.0
            ELSE
C             not identity, but same properties
              CON(I) = 0.9
            END IF
         ELSE
           CON(I) = 0.9 - 0.1 * CONCNT
         END IF
10    CONTINUE
C
      END
