C******************************************************************
      subroutine segcom(lena,lenb,ibseq)
C------------------------------------------------------------------
C Subroutine to perform segment comparisons between
C the block_file sequence(s) and another sequence
C The resulting matrix of pairscores is output to unit 99
C for subsequenct processing using program DIAPLOT
C
C Author:  Geoff Barton
C------------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'matloc.blk'
      include 'gapmis.blk'
C
C --  passed variables
      integer lena,lenb,ibseq
C
C --  local variables
      integer i,j,jc,ic,jk,ik
      real cval
C
C --  loop over the length of the sequence
      do 10,j = 1,(lenb-iwind+1)
C --     initialize the next pass
         jc = j + (iwind/2)
         cval = 0.0
         jk = j
         do 5,ik = 1,iwind
            cval = cval + lookup(ik,iseq(ibseq,jk))
            jk = jk +1
5        continue
C --     loop over the length of the lookup table
         do 20,i=1,(lena-iwind+1)
            ic = i + (iwind/2)
C --        write out the score for this pair of segs
            write(99,901)ic,jc,cval
901         format(1x,2i5,f20.10)
            cval = cval - lookup(i,iseq(ibseq,j)) +
     -                    lookup(i+1,iseq(ibseq,j))
20       continue
10    continue
C
C
      end
C


