C****************************************************************
      subroutine slook(kpos)
C----------------------------------------------------------------
C  G. J. Barton (1987)
C
C subroutine to save the lookup table to the file 'lfile'
C appending the comment 'lcmt' to the top of the file
C FORMAT of output
C
C line
C  1      !Comment line (same as filename if undefined by save_lookup_comment)
C         >i5  !index of the lookup row followed by-
C         14(a1,f7.2,',') where a1 is a one-letter amino acid code
C                         f7.2 is the score for this acid at this position
C                         ',' is a field divider to allow simple free format
C                         input by subroutine rlook
C
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'param2.blk'
      include 'matloc.blk'
      include 'gapmis.blk'
      include 'dayhof.blk'
C
      integer kpos,i,j,endfin
C
C --write the comment line to the file
      if(.not.comnd(38))then
        lcmnt = lfile
      end if
      call amess(iolook,0,lcmnt,0,' ')
C
C --write out each row of the lookup table
C   write gaps as '-' then return gaps to ' '
      acids(0)='-'
      do 10,j=1,kpos
         write(iolook,100)j
         write(iolook,101)(acids(i),lookup(j,i),i=0,13)
         write(iolook,101)(acids(i),lookup(j,i),i=14,23)
10    continue
      acids(0) = ' '
100   format(1x,'>',i5)
101   format(1x,14(a1,f7.2,','))
C
      call amess(iout,0,'Lookup table saved to file: '//
     -     lfile(:endfin(lfile)),1,'-')
C
      end
