C*******************************************************************
      subroutine gjplot(simmat,n,nentry,ident)
C-------------------------------------------------------------------
C subroutine to plot dendrograms (called from CLUST)
C This routine adapted from the SIMPLEPLOT version
C but produces PostScript
C
C G.J.B.  17/2/1992
C
C Note, there are undoubtedly redundant variables passed in common
C to this routine.  This is the result of splitting a larger program
C-------------------------------------------------------------------
C      implicit undefined(a-z)
C
C include file of virtually everything
C
      include 'clust.blk'
C
C      integer tpoint
      real tpoint
      real lwidth,mint,maxt,intt,xpos
C     real  xmin,xmax,ymin,ymax,xfac,yfac,pwidth,pheight
      real  ymax,pwidth,pheight
      logical error
C      integer endfin
      logical ablank
C
C --------------------------------------------------------------
C this section could be proceduralised as it is solely concerned
C with plotting th result of the cluster analysis by using
C the Simpleplot routines
C---------------------------------------------------------------
C
C --  Open file for plot output
      call qmess(6,5,1,'Enter plot filename: ',line)
      if(error)then
        call amess(6,1,'Error reading command',1,' ')
        stop
      end if
      write(6,*)'Opening: ',line(1:endfin(line))
      open(unit=7,status='new',
     -file=line(:endfin(line)),iostat=ios)
      if(ios.ne.0)then
        call amess(6,1,'Error opening file',1,'e')
        return
      end if

C --  ask nicely for the title and xaxis title and text mag
      CALL QMESS(6,5,1,'Please enter the axis title :',xtit)
      CALL QMESS(6,5,1,'Please enter the plot title :',tit)
C      CALL QMESS(6,5,1,'Vertical format ?? (def = horizontal) ',
C     -LINE)
C      IF(INDEX(LINE,'V').GT.0)THEN
C         VERT=.FALSE.
C	 call amess(6,1,'Vertical option disabled ',1,' ')
C      ELSE
         VERT=.FALSE.
C      END IF
C
1112  continue
      tpoint = 12.0
      error = .false.
      call qmess(6,5,1,'Enter text point size [12]: ',line)
      if(.not.ablank(line))call reacom(line,tpoint,error)
      write(6,*)'tpoint:',tpoint
      if(error)then
        call amess(6,1,'Error reading point size',1,'e')
        goto 1112
      end if
C
1113  continue
      lwidth = 0.5
      error = .false.
      call qmess(6,5,1,'Enter linewidth [0.5]: ',line)
      if(.not.ablank(line))call reacom(line,lwidth,error)
      if(error)then
        call amess(6,1,'Error reading linewidth',1,'e')
        goto 1113
      end if
C
C --  set page size
C      CALL QMESS(6,5,1,'A3 OR A4 SIZE ? (DEF=A4) ',LINE)
      IF(INDEX(LINE,'A4').GT.0)THEN
C        CALL PAGE(25.0,18.0)
      ELSE
C        CALL PAGE(42.0,29.0)
      END IF
C
      DIVIT = 10.0
      XRANGE = CSCORE(1)-CSCORE(NCLUST)
C
C --  scale the plot so that min x is a bit less than
C     the min value to be plotted, and max x is a bit more
C     than the max value to be plotted.  Ymin = 0 and y max
C     is the number of entries +1
      ABIT = XRANGE/DIVIT
      XMAX = CSCORE(1)+2.0*ABIT
      xmin = cscore(nclust)-xrange/divit
      xmax = xmax + abit/2.0
      ymin = 0.0
      ymax = float(nentry)+1.0
      pwidth = 6.0
      pheight = 10.0
      xfac = 72*pwidth/(xmax-xmin)
      yfac = 72*pheight/(ymax-ymin)
C
      write(7,9990)
9990  format('%!')
      write(7,9991)tpoint
9991  format(1x,'/Times-Roman findfont ',f8.2,' scalefont setfont')
      write(7,9997)lwidth
9997  format(1x,'35 72 translate'/1x,f7.2,' setlinewidth')
C
      write(6,6777)cscore(nclust),cscore(1)
6777  format(1x,'Minimum score: ',f8.2,' Maximum score: ',f8.2)

6677  continue
      write(6,6778)
6778  format(1x,'Enter Min and Max values for Tick marks and interval')
      read(5,*,err=1139)mint,maxt,intt
C
C --  set up and draw Xaxis ( no yaxis is required)
      write(7,9711)(mint-xmin)*xfac,0.0,(maxt-xmin)*xfac,0.0
9711  format(1x,2f8.2,' moveto'/2f8.2 ' lineto stroke')
C
C --  do some tick marks
      xpos = mint
2221  continue
      if(xpos .gt. maxt+(maxt-mint)/1000)goto 2222
      call drtick((xpos-xmin)*xfac,0.0,
     -            (xpos-xmin)*xfac,0.0-10.0,
     -            (xpos-xmin)*xfac,0.0-20.0,xpos)
      xpos = xpos + intt
      goto 2221
2222  continue
C
C --  do the x-title
      write(7,7720)(((mint+maxt)/2)-xmin)*xfac,0.0-30.0,xtit
7720  format(1x,2f8.2,' moveto (',a,') show')
C
C --  do the figure title
      write(7,7720)(xmax-xmin)*0.5*xfac,((ymax-ymin)*yfac),
     -              tit
C      IF(VERT)THEN
C         CALL TEXTMG(TMAG)
C         CALL YAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C         CALL TEXTMG(1.0)
C      ELSE
C         CALL XAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C      END IF
C
C --  Set up a pointer array to the positions of elements to
C     be plotted
      DO 91,I=1,NCTOT(NCLUST)
         POINT(CTOTAL(NCLUST,I)) = I
91    CONTINUE
C
C --  write the identifying numbers down the rhs of plot
C     or across the top if vert=.t.
C      CALL TEXTMG(TMAG)


      DO 92,I=1,NCTOT(NCLUST)
          write(7,9992)((cscore(1)+abit)-xmin)*xfac,
     -                  (float(i)-ymin)*yfac,
     -                  ctotal(nclust,i),
     -                  ident(ctotal(nclust,i))
92    CONTINUE
9992  format(1x,2f8.2,' moveto (',i7,' ',a,') show')
C
C --  start drawing the cluster diagram by going down the list
C     stored in CPAIRS
      DO 93,I=1,NCLUST
C        if we are joining a cluster then find the mean Y position
C        otherwise set the value to the y position of the element
C        do the first of the pair
         IF(CPAIRS(1,I).GT.CADD)THEN
            TINDEX = CPAIRS(1,I)-CADD
            TOT = 0.0
            DO 94,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
94          CONTINUE
            Y(1) = ((TOT/NCTOT(TINDEX))-ymin)*yfac
            X(1) = (CSCORE(TINDEX)-xmin)*xfac
            X(2) = (CSCORE(I)-xmin)*xfac
         ELSE
            Y(1) = (POINT(cpairs(1,i))-ymin)*yfac
            X(1) = (CSCORE(1)+ABIT-xmin)*xfac
            X(2) = (CSCORE(I)-xmin)*xfac
         END IF
C
C --     do the second of the pair
         IF(CPAIRS(2,I).GT.CADD)THEN
            TINDEX = CPAIRS(2,I)-CADD
            TOT = 0.0
            DO 95,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
95          CONTINUE
            Y(4) = ((TOT/NCTOT(TINDEX))-ymin)*yfac
            X(4) = (CSCORE(TINDEX)-xmin)*xfac
          ELSE
            Y(4) = (POINT(cpairs(2,i))-ymin)*yfac
            X(4) = (CSCORE(1)+ABIT-xmin)*xfac
          END IF
C
C --      now call jclust to join the points up
          CALL JCLUST(X,Y,4,VERT)
93    CONTINUE
C
C --
C      CALL TITLE7('H','C',TIT(1:ENDFIN(TIT)))
C
C --
C      CALL ENDPLT
       write(7,9995)
9995   format(' stroke'/' showpage')
       goto 1132

C
1139   continue
       call amess(6,1,'Error: Try something like 1 10 1',1,'e')
       goto 6677
1132   continue
       END
C
C**************************************************************
      SUBROUTINE JCLUST(X,Y,N,VERT)
C--------------------------------------------------------------
C      implicit undefined(a-z)
C
      INTEGER I,N
      REAL X(N),Y(N),XV(4),YV(4)
      LOGICAL VERT
C
      Y(2) = Y(1)
      Y(3) = Y(4)
      X(3) = X(2)
C
      IF(VERT)THEN
        XV(1)=Y(4)
        YV(1)=X(4)
        XV(2)=Y(3)
        YV(2)=X(3)
        XV(3)=Y(2)
        YV(3)=X(2)
        XV(4)=Y(1)
        YV(4)=X(1)
      END IF
C
      IF(VERT)THEN
        write(7,9996)xv(1),yv(1)
        DO 11,I=1,N
           write(7,9997)xv(i),yv(i)
C           CALL JOIN PT(XV(I),YV(I))
11      CONTINUE
      ELSE
        write(7,9996)x(1),y(1)
        DO 10,I=1,N
           write(7,9997)x(i),y(i)
C           CALL JOIN PT(X(I),Y(I))
10      CONTINUE
      END IF
9996  format(1x,2f8.2,' stroke moveto')
9997  format(2f8.2,' lineto')

C
C
C     CALL BREAK
C

      END
C
C
      subroutine drtick(x,y,x1,y1,x2,y2,val)
C
C draw line from x,y to x1,y1 
C
      real x,y,x1,y1,x2,y2,val
      call pmove(x,y)
      call pline(x1,y1)
      call pstroke
      call pval(x2,y2,val)
C
      end
C
      subroutine pmove(x,y)
      real x,y
      write(7,7771)x,y
7771  format(1x,2f10.2,' moveto')
      end
C
      subroutine pline(x,y)
      real x,y
      write(7,7771)x,y
7771  format(1x,2f10.2,' lineto')
      end
C
      subroutine pstroke
      write(7,7771)
7771  format(1x,' stroke')
      end
C
      subroutine pval(x,y,val)
      real x,y,val
      write(7,7771)x,y,val
7771  format(1x,2f10.2,' moveto (',f7.2,') show')
      end
