#!/usr/local/bin/perl
#
# This takes the output of the program patt
# deletes lines between the <x:y from the position p that
# <x:y is in the file to the position p+y+1
# 
# It also loses extraneous lines and the horizontal output of patt
#
# The bottom line is that this routine produces output suitable
# for feeding back into amps for a second round of pattern scanning
#
# Usage:  parse_patt -kc < pattern file > parsed file
#
# If parse_patt is called with the argument "-k", then the pattern that
# was used to create the alignment file is kept in the alignment and 
# additional >IDENT lines are added to the file.
# If "-k" is absent, then the sequence lines relating to the 
# pattern are deleted from the file.
#
# if -c is present, then the routine does not delete the gmax lines
# following the pattern definition.  It just deletes the blank lines
#
# parse_patt -k   gives output suitable for flexible pattern matching.
# parse_patt      ditto.
# parse_patt -c or -kc gives output suitable for a profile scan.
#
require 'getopts.pl';

$keep_pattern = 0;
$save_all = 0;

&Getopts('kc');

if($opt_k){
    $keep_pattern = 1;
}
if($opt_c){
    $save_all = 1;
}

@patt = <STDIN>;

#just keeps track of * symbols in the second column of the file
$star_counter = 0;

# First find the location of the first - symbol.  This is above
# the first of the new sequences in the block file
foreach $line (@patt){
    if($line =~ /^ {2}/){
	$pos = index($line,"_");
	last if($pos > -1);
    }
}
#print "POSITION $pos\n";

if($keep_pattern == 1){
    foreach $i (1 .. $pos-1){
	print " >PATTERN             Pattern used to scan\n";
    }
}

foreach $i (0 .. $#patt){
    if($patt[$i] =~ / \*/){
	++$star_counter;
	if($star_counter == 1){
	    print " *";
	}
    }
    if($save_all != 1){
#	print "HERE\n";
	#get rid of the lines following a :gmax
	if($patt[$i] =~ /<\d+:/){
	    # get the upper gap bound - gosh isn't this easy!
	    $gmax = substr($patt[$i],index($patt[$i],":")+1);
	    $gmax =~ s/\s+//g;
	    $j = 1;
	    while($j <= $gmax){
		$patt[$i+$j] =~ s/\w/ /g;
		++$j;
	    }
	}
    }

    if($star_counter < 2){
	#don't do anything with blank lines
	if($patt[$i] =~ /\w/){
	    if($star_counter == 0){
		    print $patt[$i];
	    }elsif($star_counter == 1){
		if($keep_pattern == 0){
		    $pm1 = $pos-1;
		    #lose the pattern sequences
		    $patt[$i] =~ s/^ .{$pm1}/ /;
		}
		print $patt[$i];
	    }
	}
    }
}

print " *";
