#include <stdio.h>
#include <stdlib.h>
#include "defaults.h"
#include "array.h"

int getseq();
int getid();
int getline();

/*************************************************************************
gseq - read the next sequence from the sqfile.
If convert = 1 then we are reading a sequence file, so strip non-alphabetic
characters and convert to integer.
Otherwise read all characters until * (except white space).

27th Nov. 1990 - Fix bug, If gseq is called with nseq = a sequence entry that
has previously been used, (ie seqs[*nseq].slen > 0), then use realloc rather
than malloc to allocate the space for the entry!!
-------------------------------------------------------------------------*/
int gseq(sqfile,seqs,nseq,convert)

FILE *sqfile;
struct seqdat *seqs;
int *nseq;
int convert;

{
    int i;
    extern int MAXnseq, MAXslen, MAXilen, MAXtlen;

   if(*nseq < MAXnseq-1){
	/* allocate or reallocate space for identifier */
	if(seqs[*nseq].slen == 0){
	    /* first allocation */
	    seqs[*nseq].id = malloc(MAXilen*CSIZ);
	    mcheck(seqs[*nseq].id,"No space for ID - gseq - (1)");
	}else{
	    /* re-use of this entry */
	    seqs[*nseq].id = realloc(seqs[*nseq].id,MAXilen*CSIZ);
	    mcheck(seqs[*nseq].id,"No space for ID - gseq - (2)");
	}
        /* read identifier from file */
	if((seqs[*nseq].ilen = getid(sqfile,seqs[*nseq].id,MAXilen)) > 0){
	    /* if ident short then reallocate space (possible bug here, if id is longer 
	       than the MAXilen */
	    if(seqs[*nseq].ilen != MAXilen){
		seqs[*nseq].id = realloc(seqs[*nseq].id,CSIZ*seqs[*nseq].ilen);
		mcheck(seqs[*nseq].id,"No space for ID - gseq - (3)");
	    }
	}else{
/*	    fprintf(stderr,"EOF before ID\n");*/
	    return 0;
	}
	/* allocate/reallocate space for title */
	if(seqs[*nseq].slen == 0){
	    seqs[*nseq].title = malloc(MAXtlen*CSIZ);
	    mcheck(seqs[*nseq].title,"No space for TITLE - gseq (1)");	    
	}else{
    	    seqs[*nseq].title = realloc(seqs[*nseq].title,MAXtlen*CSIZ);
	    mcheck(seqs[*nseq].title,"No space for TITLE - gseq - (2)");	    
	}
	/* read the title */
        if((seqs[*nseq].tlen = getline(sqfile,seqs[*nseq].title,MAXtlen)) > 0){
	    if(seqs[*nseq].tlen != MAXtlen){
		seqs[*nseq].title =
		realloc(seqs[*nseq].title,CSIZ*seqs[*nseq].tlen);
		mcheck(seqs[*nseq].title,"No space for TITLE - gseq - (3)");
	    }
	}else{
	    fprintf(stderr,"End of file before title found\n");
	    return 0;
	}
	/* Allocate/reallocate space for sequence */
	if(seqs[*nseq].slen == 0){
	    seqs[*nseq].seq = malloc(MAXslen*CSIZ);
	    mcheck(seqs[*nseq].seq,"No space for SEQ - gseq - (1)");
	}else{
    	    seqs[*nseq].seq = realloc(seqs[*nseq].seq,MAXslen*CSIZ);
	    mcheck(seqs[*nseq].seq,"No space for SEQ - gseq - (2)");
	}
	/* read the sequence lines */
	if(convert){
	    /* read sequence and ignore non-alphabetic characters */
	    if((seqs[*nseq].slen = getseq(sqfile,seqs[*nseq].seq,MAXslen)) <= 0){
		fprintf(stderr,"Zero length sequence: %s\n",seqs[*nseq].id);
		return 0;
	    }
	}else{
	    /* read all characters except blank */
	    seqs[*nseq].slen = getsec(sqfile,seqs[*nseq].seq,MAXslen);
	}
	/* reallocate unused memory */
	if(seqs[*nseq].slen != MAXslen){
	    seqs[*nseq].seq = realloc(seqs[*nseq].seq,seqs[*nseq].slen*CSIZ);
	    mcheck(seqs[*nseq].seq,"No space for SEQ - gseq - (3)");
	}
	/* do character to integer conversion */
	if(convert == 1) seqtoi(seqs[*nseq].seq,seqs[*nseq].slen);
	return 1;
   }else{
       return 0;
   }

}

/*****************************************************************************
print a sequence file to ofile in NBRF format.
-----------------------------------------------------------------------------*/

int pseq(ofile,seqs,nseq)

FILE *ofile;
struct seqdat *seqs;
int *nseq;

{
    int k;
    fprintf(ofile,">%s\n",seqs[*nseq].id);
    fprintf(ofile,"%s\n",seqs[*nseq].title);
    for(k = 1; k < seqs[*nseq].slen-1; ++k){
	fputc(seqs[*nseq].seq[k],ofile);
    }
    fprintf(ofile,"*\n");
    fflush(ofile);
    return 1;
}
