C***************************************************************
      SUBROUTINE ALMUL(M,N,LOCA,LOCB,KPOS,IBSEQ,IFIN)
C--------------------------------------------------------------
C This subroutine uses the pointer array LOC(*,*) to align the
C current sequence with those already aligned
C
C Author: G.J.Barton, Copyright 1985 all rights reserved.
C
C M           length of already aligned sequences
C N           length of sequence to align now
C LOCA        pointer to starting point(=0) if not in column 1
C LOCB        pointer to starting point(=0) if not in row 1
C KPOS        length of sequences after alignment
C IBSEQ       index of seqence to align this time
C IFIN        number of sequences already aligned
C
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'matloc.blk'
C
      integer m,n,loca,locb,kpos,ibseq,ifin
C
      integer IOLD,JOLD,INEXT,JNEXT,
     -        IDIFF,JDIFF,IJ,IZ,IVAL

      iold = 0
      jold = 0
      inext = 0
      jnext = 0
      idiff = 0
      jdiff = 0
      ij = 0
      iz = 0
      ival = 0
C---------------------------------------------------------------
C      IOLD,JOLD = THE COORDS OF THE LAST ARRAY ELEMENT OF LOC
C      INEXT,JNEXT = THE COORDS OF THE NEXT/CURRENT ELEMNT LOC
C---------------------------------------------------------------
      IOLD=0
      JOLD=0
      KPOS=0
C---------------------------------------------------------------
C      LOCATE FIRST ELEMENT OF MAX MATCH USING LOCA,LOCB
C---------------------------------------------------------------
      IF(LOCA.EQ.0)THEN
         INEXT=1
         JNEXT=LOCB
      ELSE
         INEXT=LOCA
         JNEXT=1
      END IF
C---------------------------------------------------------------
C      CALCULATE DIFFERENCE IN I AND J INDICIES WHEN PROCEEDING
C      FROM IOLD,JOLD TO INEXT,JNEXT
C---------------------------------------------------------------
1000  IDIFF=INEXT-IOLD
      JDIFF=JNEXT-JOLD
C---------------------------------------------------------------
C      A VALUE OF IDIFF .GT.1 INDICATES AN INSERT IN SEQA
C      A VALUE OF JDIFF .GT.1 INDICATES AN INSERT IN SEQB
C      IF IDIFF=JDIFF=1 THEN THER IS NO INSERTION
C      KPOS IS THE CURRENT INDEX IN OUTA(KPOS),OUTB
C---------------------------------------------------------------
      IF(IDIFF.GT.1)THEN
         DO 200,IJ=(IOLD+1),INEXT
            KPOS=KPOS+1
            DO 1,IZ=0,IFIN
               IF(IBSEQ.EQ.IZ)GO TO 1
               IOUTSQ(IZ,KPOS)=ISEQ(IZ,IJ)
1           CONTINUE
            IOUTSQ(IBSEQ,KPOS)=0
            IF(IJ.EQ.INEXT)THEN
              IOUTSQ(IBSEQ,KPOS)=ISEQ(IBSEQ,JNEXT)
            END IF
200         CONTINUE
      ELSE IF(JDIFF.GT.1)THEN
         DO 300,IJ=(JOLD+1),JNEXT
            KPOS=KPOS+1
            IOUTSQ(IBSEQ,KPOS)=ISEQ(IBSEQ,IJ)
            DO 2,IZ=0,IFIN
              IF(IBSEQ.EQ.IZ)GO TO 2
              IOUTSQ(IZ,KPOS)=0
2           CONTINUE
            IF(IJ.EQ.JNEXT)THEN
              DO 3,IZ=0,IFIN
                 IF(IBSEQ.EQ.IZ)GO TO 3
                 IOUTSQ(IZ,KPOS)=ISEQ(IZ,INEXT)
3             CONTINUE
            END IF
300         CONTINUE
      ELSE
         KPOS=KPOS+1
         DO 4,IZ=0,IFIN
            IF(IBSEQ.EQ.IZ)GO TO 4
            IOUTSQ(IZ,KPOS)=ISEQ(IZ,INEXT)
4        CONTINUE
         IOUTSQ(IBSEQ,KPOS)=ISEQ(IBSEQ,JNEXT)
      END IF
C---------------------------------------------------------------
C      UPDATE IOLD,JOLD
C      THEN INTERROGATE LOC(IOLD,JOLD) TO DISCOVER THE VALUES
C      OF NEXTI,NEXTJ
C      A VALUE OF LOC( , ) GT THOU INDICATES AN INSERTION IN
C      SEQB
C      THIS IS JUST A CONVENIENT WAY OF CODING THE TYPE OF
C      INSERTION SEQA OR SEQB
C      SEE SUBROUTINE RECURS FOR DETAILS OF LOC CREATION
C--------------------------------------------------------------
      IOLD=INEXT
      JOLD=JNEXT
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE  IE IOLD=M-1,OR JOLD=N-1
C---------------------------------------------------------------
      IF(IOLD.EQ.(M).OR.JOLD.EQ.(N))THEN
      ELSE
          IVAL=LOC(IOLD,JOLD)
          IF(IVAL.GT.THOU)THEN
             INEXT=IOLD+1
             JNEXT=IVAL-THOU
          ELSE
             INEXT=IVAL
             JNEXT=JOLD+1
          END IF
          GO TO 1000
      END IF
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE AND INSERT BLANKS IN THE
C      APPROPRIATE OUT(A/B) ARRAY
C---------------------------------------------------------------
      IF((IOLD.EQ.M).AND.(JOLD.EQ.N))THEN
         DO 5,IZ=0,IFIN
            IF(IBSEQ.EQ.IZ)GO TO 5
            IOUTSQ(IZ,KPOS)=ISEQ(IZ,M)
5        CONTINUE
         IOUTSQ(IBSEQ,KPOS)=ISEQ(IBSEQ,N)
         RETURN
      ELSE IF(IOLD.EQ.M)THEN
         DO 400,IJ=JNEXT+1,N
            KPOS=KPOS+1
            DO 6,IZ=0,IFIN
               IF(IBSEQ.EQ.IZ)GO TO 6
               IOUTSQ(IZ,KPOS)=0
6           CONTINUE
            IOUTSQ(IBSEQ,KPOS)=ISEQ(IBSEQ,IJ)
400         CONTINUE
         RETURN
      ELSE IF(JOLD.EQ.N)THEN
         DO 500,IJ=INEXT+1,M
            KPOS=KPOS+1
            DO 7,IZ=0,IFIN
               IF(IBSEQ.EQ.IZ)GO TO 7
               IOUTSQ(IZ,KPOS)=ISEQ(IZ,IJ)
7           CONTINUE
            IOUTSQ(IBSEQ,KPOS)=0
500         CONTINUE
         RETURN
      END IF
      END
C---------------------------------------------------------------
