C********************************************************
      PROGRAM AMULT
C--------------------------------------------------------
C Multiple Protein Sequence alignment program
C
C Author: G.J. Barton Copyright(1985,1997) All rights reserved.
C
C Address from 1/10/1997: EMBL-European Bioinformatics Institute
C			  Wellcome Trust Genome Campus
C                         Hinxton Cambridge, CB10 1SD
C Tel: 01223 494414
C Fax: 01223 494496
C
C Preferred contact via e-mail.
C
C geoff@ebi.ac.uk
C
C
C Version 3.0: this version does not have MAT array at all
C              but uses the function SCORE repeatedly
C              instead
C
C              This can read a .ORD file to define the order
C              of alignment
C
c              includes a call to conser to calculate
C              conservation based on the Dayhoff matrix.
C              Writes out the mean score  for the
C              alignment.
C
C              Includes the option to specify a file containing
C              defined regions (eg alpha helices/beta sheets)
C              for testing purposes. (TESTER.BLK)
C
C Revision (version 3.0) (1987)
C
C Now accepts key word commands for specifying user defined data
C ie files, gap-penalties print instructions etc.
C Key words must be stated completely and followed by an = sign.
C
C key words defined in version 3.0:
C SEE subroutine MASTER for details
C
C Version 3.1:  Includes option to score gaps differently on iteration
C Version 3.2:  allows up to 2 blocks of prealigned sequences to be
C               aligned with each other.
C Version 3.3:  does not allow two blocs to be aligned but does allow
C               a bloc to be compared to all sequences in a database
C               file
C Version 3.4:  Faster version which uses a lookup table of scores
C               for each amino acid position in the currently aligned
C               sequences.  (see subroutine MLOOK) (May 1987)
c version 4.0:  includes gap_factor option when using a block file
C               regions of the block may be biased against or for
C               gaps a la Barton and Sternberg Prot. Eng.(1987)
C Version 4.1   Has pattern matching option
C Version 4.2   has GJSCAN option
C Version 4.5   Has Dodd and Egan weight matrix option
C
C Version 5.0   This reorganises the command input to subroutine MASTER
C               to allow a more rational assignment of available options
C               MODE = multiple
C
C         5.1   Includes the option to perform pairwise comparisons
C               (basically the same as program bmult)
C
C Version 6.0   Includes option to align sequences following an
C               evolutionary tree. TREE_FILE is defined by the program
C               ORDER.
C
C Version 6.1   Includes option to compare the contents of a PSFILE 
C               containing any number of sequences to a DATABASE file
C               containing any number of sequences, using a simple
C               pairwise algorithm.
C
C Version 6.2   Allows corner cutting in pairwise mode  SPEEDUP = K
C
C 10/9/91:  Increase length of IDENTS to 20 characters.
C
C Version 7.0   12/Aug/1993
C
C               Major bug fix:  There was an error in the TREE mode
C               this led to strange alignments when large numbers of
C               sequences are included.
C
C               Add USE_END_PEN command.  Weights gaps at overhangs
C               (Only works in TREE mode).
C
C Version 7.1   11/11/1993
C               Add initialisation routine.  Check most routines for
C               uninitialised variables (!)
C               In pattern scanning mode avoid comparing to sequences
C               shorter than the minimum pattern length
C               
C
C--------------------------------------------------------------------
C
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'conser.blk'
      include 'tester.blk'
      include 'param2.blk'
      include 'probas.blk'
C
      include 'speedo.blk'
C
      INTEGER ITS,I,J,KPOS
C
C -- initialisation - be safe
      i = 0
      j = 0
      its = 0
      kpos = 0

      call initall
C
C
C
C --  call master to read commands on channel ICOM
C
      CALL MASTER
C
C --skip this lot if PSFILE has been defined.
C
      if(.not.comnd(49))then
C
C --  write out sequence info
C
      IF(COMND(20))THEN
          CALL AMESS(IOUT,1,'PATTERN defined in BLOCK file: ',
     -    1,' ')
          CALL WNAMES(1,RBLOC(2,1))
      ELSE IF(COMND(14))THEN
          CALL AMESS(IOUT,1,'Sequences defined in BLOCK file:',
     -    1,'-')
          CALL WNAMES(1,RBLOC(2,1))
      END IF
      IF(COMND(3))THEN
        CALL AMESS(IOUT,1,'Sequences defined in SEQ file:',
     -  1,'-')
        CALL WNAMES(RBLOC(2,1)+1,INUMB)
      END IF
C
C --  convert sequences to INTEGER values
C
      CALL KONCOM(INUMB)
C
C --  decode the gap-factor ranges if specified
C
      IF(COMND(19))THEN
        CALL DCGAPS
      END IF
C
C --  add const to  dayhoff matrix if requested
C
      end if
      IF(CONST.GT.0)THEN
        DO 345,I=1,23
           DO 345,J=1,23
              DAY(J,I)=DAY(J,I)+CONST
345     CONTINUE
      END IF
C
C --  write out pairscore matrix if requested
C
      IF(COMND(13))THEN
        CALL WMATR(IOUT)
      END IF
C
C-----carry out alignments
C
      KPOS=NUMB(1)
C     loop over number of iterations required (at least one!)
      DO 1100,ITS=1,NITS
C
C --     if a gapmask has been defined set up DAY matrix
         IF(COMND(12))THEN
           CALL SETGAP(ITS)
         END IF
C
C --
601      FORMAT('1*  ITERATION',I5)
C         CALL LIB$INIT_TIMER()
         if (its.eq.1)then
            call timer1(ierr)
         end if
C
         if(.not.(modes.eq.3))then
           if((comnd(207) .and. its .eq. nits) .or. .not.comnd(207))then
             write(iout,601)ITS
           end if
         end if
C
         IF(modes.eq.1)THEN
           if(comnd(40))then
C --         do a tree based alignment
             call tmult
           else
C            multiply align the individual sequences in order
             CALL MULTA(ITS,KPOS)
           end if
         ELSE if (modes.eq.2)then
C          align sequences from database to block in turn
           CALL MULTB(KPOS)
C           CALL WRITE6(KPOS,INUMB,IOUT)
         else if(modes.eq.3)then
           if(comnd(49))then
C             use PSFILE to compare pairwise to database
              call multd
           else
C             align sequences pairwise
              call multc
           end if
         END IF
C         CALL LIB$SHOW_TIMER()
         call timer2(ierr)
1100  CONTINUE
      STOP
      END
C--------------------------------------------------



      subroutine initall

      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'conser.blk'
      include 'tester.blk'
      include 'param2.blk'
      include 'probas.blk'
C
      include 'speedo.blk'
C -- initialise all variables before use !!

C     jseed initialises srand - now done here rather
C     than in scram and scramc  21/5/1997

      integer jseed

      integer i,j,k
      i = 0
      j = 0
      k = 0

      call initi(con,maxdim,0)

      do 20,i=0,23
         acids(i) = ' '
         do 20, j=0,23
            day(j,i) = 0
 20   continue

      do 30,i=1,80
         title(i:i) = ' '
         lfile(i:i) = ' '
         lcmnt(i:i) = ' '
 30   continue

      call initc(idents,maxseq,' ')
      call initc(names,maxseq,' ')

      call initr(rmatch,maxran,0.0)
      rmean = 0.0
      rsd = 0.0
      nrans = 0
      
      call initi(gapmin,maxdim,0)
      call initi(gapmax,maxdim,0)
      call initi(ord,maxseq,0)
      call initi(locp,maxseq,0)
      call initr(scr,maxseq,0)

      match = 0.0
      qfac = 0.0
      call initr(gapfac,maxdim,0.0)
      gap = 0.0
      accval = 0.0

      prmin = 0
      prmax = 0
      princ = 0
      iwind = 0
      nlevel = 0
      mindbl = 0
      pidcut = 0
      
C intseq.blk
      do 40,i=1,maxdim+10
C SMJS From JC         numb(i) = 0
         jaout(i) = 0 
         jbout(i) = 0
         do 40,j=0,maxseq
            iseq(j,i)=0
            ioutsq(j,i)=0
 40   continue

C SMJS Added From JC
      do 41, i=1,maxseq
         numb(i) = 0
 41   continue
C SMJS End added

      do 50, i=1,maxdim
         jaseq(i) = 0
         jbseq(i) = 0
 50   continue

C -- matloc

      do 60,i=1,maxdim
         do 60, j=1,maxpat
            loc(j,i) = 0
 60   continue

      do 70, i=0,23
         do 70, j=1,maxdim+10
            lookup(j,i) = 0.0
 70   continue

      call initr(mrows,maxdim,0.0)
      call initr(oldcol,maxdim,0.0)
      call initr(newcol,maxdim,0.0)
      maxcol = 0
      maxrow = 0
      marrow = 0
      macol = 0
      amaxi = 0
      bmaxj = 0
      elm = 0
      elmp1 = 0

      call initr(toprow,maxdim,0.0)
      call initi(lrows,maxdim,0)
      
      loccol = 0
      locrow = 0

C -- params

      call initi(gmask,maxmas,0)
      nmask = 0
      do 80,i=1,maxblc
         do 80, j=1,2
            rbloc(j,i) = 0
 80   continue

      const = 0
      nits = 0
      inumb = 0
      minpat = 0
      modes = 0
      ipseq = 0

      call initl(comnd,maxcom,.FALSE.)

      pfull = .false.
      ppret = .false.
      test = .false.

C -- probas
      
      do 90,i=0,23
         aprobs(i) = 0.0
 90   continue

C -- seqcha

      do 100, i=0,maxseq
         do 100, j=1,maxdim+10
            seq(j,i) = ' '
 100  continue

      do 110, i=1,maxdim+10
         aseq(i) = ' '
         bseq(i) = ' '
 110  continue

C -- speedo 

      fcut = 0.0
      fm = 0.0
      fn = 0.0
      fk = 0.0
      jt = 0.0
      fk1 = 0.0
      uval = 0
      lstrt = 0
      lstart = 0

C -- tester

      do 120, i=1,mseq2
         do 120, j=1,maxreg
            do 120, k=1,2
               temlat(k,j,i) = 0
 120  continue

      do 130, i=1,mseq2
         tempt(i) = 0
 130  continue

      do 140, i=1,2
         do 140, j=1,maxdim+10
            plates(j,i) = 0
 140  continue

      nreg = 0
      
      do 150, i=1,mseq2
         do 150, j=1,mseq2
            tscore(j,i) = 0.0
 150  continue

      call initc(tident,mseq2,' ')

C --  initialise srand 

      jseed = -3121597
      call srand(jseed)

      end


      

         


        
      


