C***************************************************************
      SUBROUTINE RECPF(LENA,LENB,G3,MATCH,
     -                  ALOC,BLOC)
C---------------------------------------------------------------
C Revised version includes corner-cutting features.
C
C Revised version for pairwise comparisons within the program
C amult. (1987)
C
C
C New version which does not operate on a complete MAT array
C This only requires the lookup table and the integer
C sequences.
C
C Author: G. J. Barton
C         Copyright 1986 all rights reserved
C
C LENA     length of sequence(s) already aligned
C LENB     length of sequence(s) to be aligned
C G3       length independent gap penalty
C MATCH    maximum match score
C ALOC     start point of best path through LOC(*,*) (row 1)
C BLOC       '    '    '   '    '      '      '      (col 1)
C
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'dayhof.blk'
C
C --common blocks with corner cutting parameters.  fcut, fm fn,fk,jt
      include 'speedo.blk'
      include 'param2.blk'
C

C
C --  passed variables
      REAL MATCH,G3
      integer lena,lenb,aloc,bloc
C
C --  local variables
      integer I,IP1,J,JP1,K
C
      REAL AMIN,ZERO
      PARAMETER(AMIN=-10000.0,
     -          ZERO=0.0)
C
C
C --set up the corner cutting values
      if(comnd(47))then
C --     auto corner cutting has been defined derive fk1 from lengths
         fk1 = fk + abs(lena-lenb)
      else
         fk1 = fk
      end if
      fn = float(lenb)
      fm = float(lena)
      fcut = (fk1/sqrt(2.0))*(((fm/fn)+(fn/fm))/sqrt(fm*fm+fn*fn))
      upper = .false.
C      
      BMAXJ=AMIN
      DO 20,I=1,LENA
         MROWS(I) =AMIN
         LROWS(I) =LENB
         NEWCOL(I)=ZERO
C
C        use function score to set initial column element
C        eg: score(i,j) gives similarity between acid i,j
C        here we have the multiple alignment case
C        simple pairwise case
C
         oldcol(i) = day(jaseq(i),jbseq(lenb))
C
C         OLDCOL(I)=LOOKUP(I,ISEQ(IBSEQ,LENB))
C         write(6,*)'oldcol',i,oldcol(i)
C         OLDCOL(I)=SCORE(IBSEQ,IDIV,IFIN,I,LENB)
20    CONTINUE
C
C
C     loop over length of sequence B
      lstart = lena-1
      DO 10,J=(LENB-1),1,-1
         JP1=J+1
C        set max column score to small value
         MAXCOL=AMIN
C        set location of maxcol to sequence A length
         LOCCOL=LENA
C        set value of oldcol(lena)
C         NEWCOL(LENA)=LOOKUP(LENA,ISEQ(IBSEQ,J))
         newcol(lena)=day(jaseq(lena),jbseq(j))
C         write(6,*)'newcol',lena,newcol(lena)
C         NEWCOL(LENA)=SCORE(IBSEQ,IDIV,IFIN,LENA,J)
C
C        calculate corner cutting value for this J
         jt = j/fn
C
C        loop over length of sequence A
         DO 30,I=lstart,1,-1
            if(abs((i/fm)-jt).gt.fcut)then
C              corner cutting jump
               if(upper)then
                  uval = i
                  goto 99
               else
                  goto 30
               end if
            else
               if(.not.upper)then
                  lstrt = i
                  upper = .true.
               end if
            end if
            IP1=I+1
C           initialise scalars for maxrow score,
            MAXROW=MROWS(IP1)
C           location of maxrow score
            LOCROW=LROWS(IP1)
C           value of non-insertion case
            ELMP1=OLDCOL(IP1)
C           take into account gap-penalty
            MARROW=MAXROW-G3
            MACOL =MAXCOL-G3
C           get current element score using function Score()
C            ELM = LOOKUP(I,ISEQ(IBSEQ,J))
            elm = day(jaseq(i),jbseq(j))
C            write(6,*)'elm',elm
C            ELM = SCORE(IBSEQ,IDIV,IFIN,I,J)
C-----------
C           determine best path to ELM
C-----------
C           where ambiguity prefer no insertion to insertion
            IF(ELMP1.GE.MACOL.AND.ELMP1.GE.MARROW)THEN
              NEWCOL(I)=ELM+ELMP1
              LOC(I,J)=IP1
C
C           where ambiguity prefer column to row
            ELSE IF(MACOL.GT.ELMP1.AND.MACOL.GE.MARROW)THEN
              NEWCOL(I)=ELM+MACOL
              LOC(I,J)=LOCCOL
C
C           this should be the only alternative!!
            ELSE IF(MARROW.GT.ELMP1.AND.MARROW.GT.MACOL)THEN
              NEWCOL(I)=ELM+MARROW
              LOC(I,J)=LOCROW+THOU
            ELSE
              WRITE(6,*)'SUMMIT FUNNY HAPPENED'
            END IF
C
C           set up mrow and maxcol for next cycle
            IF(ELMP1.GE.MAXROW)THEN
               MROWS(IP1)=ELMP1
               LROWS(IP1)=JP1
            END IF
            IF(ELMP1.GE.MAXCOL)THEN
               MAXCOL=ELMP1
               LOCCOL =IP1
            END IF
30       CONTINUE
C
C --     jump to this point if corner cutting
99       continue
         upper = .false.
         lstart = lstrt
C
C        set up oldcol with the newly calculated values
         DO 40,K=uval,lena
            OLDCOL(K)=NEWCOL(K)
40       CONTINUE
C        set latest value for maxmatch and postion
         IF(OLDCOL(1).GT.BMAXJ)THEN
            BMAXJ=OLDCOL(1)
            BLOC=J
         END IF
10    CONTINUE
C
C     find max value in first column
      AMAXI=AMIN
      jt = 1/fn
      DO 50,I=1,LENA
         if(abs((i/fm)-jt).gt.fcut)then
C           even corner cut paths must be in the range
C           i=1,... so first failure to satisfy lets us out
            goto 55
         end if
         IF(OLDCOL(I).GT.AMAXI)THEN
           AMAXI=OLDCOL(I)
           ALOC=I
         END IF
50    CONTINUE
55    continue
C
C     find which max is biggest!
      IF(AMAXI.GE.BMAXJ)THEN
          MATCH=AMAXI
          BLOC=0
      ELSE IF(BMAXJ.GT.AMAXI)THEN
          ALOC=0
          MATCH=BMAXJ
      END IF
C      open(unit=8,file='newloc.bin',status='new',
C     -form='unformatted')
C      write(8)lena,lenb,((loc(i,j),i=1,lena),j=1,lenb)
C      stop
C
      END
C
