C**********************************************************
      SUBROUTINE WCHECK(IOUT,ibseq,KPOS)
C----------------------------------------------------------
C This writes out the matrix of structure comparisons
C generated by GCHECK, lower diagonal = actual values
C upper diagonal = % values
C
C Then calculates the %identity and scores for all pairs
C and writes out %ID lower diagonal
C                score upper diagonal and major diagonal
C
C VERSION 2
C           Calculates mean and SD for each comparison
C
C Author:  Geoff Barton
C----------------------------------------------------------
C
      include 'params.blk'
      include 'gapmis.blk'
      include 'tester.blk'
      include 'intseq.blk'
      include 'dayhof.blk'
C
      INTEGER I,J,II,IOUT,ibseq,K,KPOS
      REAL RDIV,TID,TALIG
C
C --
C     NENT      Number of elements to find average of
C     ASTARR,BSTARR  arrays to hold upper and lower diagonal
C     ASAV,BSAV average values
C     ASSD,BSSD standard deviations
C --
      INTEGER MAXSIZ,NENT
      PARAMETER(MAXSIZ=(MSEQ2*(MSEQ2-1))/2)
      REAL ASTARR(MAXSIZ),BSTARR(MAXSIZ),
     -     ASAV,BSAV,ASSD,BSSD

C
      CALL AMESS(IOUT,1,'Upper diagonal = SStruc regions score',0,'-')
      CALL AMESS(IOUT,0,'Lower diagonal = % accuracy ',1,'-')
C
C --  get the % accuracy
      RDIV = TSCORE(1,1)
      nent = 0
      II = 0
      DO 10,I=2,IBSEQ
         II=II+1
         DO 10,J=1,II
            TSCORE(J,I)=(TSCORE(I,J)/RDIV)*100.0
            if(j.ne.i)then
               nent=nent+1
               astarr(nent)=tscore(j,i)
               bstarr(nent)=tscore(i,j)
            end if
10    CONTINUE
      CALL STATS(ASTARR,NENT,ASAV,ASSD)
      CALL STATS(BSTARR,NENT,BSAV,BSSD)
C
C --  write it out
      CALL WRITG(IOUT,IBSEQ)
      WRITE(IOUT,101)ASAV,ASSD,BSAV,BSSD
101   FORMAT(/1X,'Mean and SD (lower diagonal) ',2f7.1,
     -        1x,'Mean and SD (upper diagonal) ',2f7.1/)

C
C --  get the % identities
      II = 0
      NENT = 0
      DO 20,I=1,IBSEQ
         II = II+1
         DO 20,J=1,II
            TID = 0.0
            TALIG = 0.0
            DO 30,K=1,KPOS
               IF(IOUTSQ(I,K).GT.0.AND.IOUTSQ(J,K).GT.0)THEN
                 TALIG = TALIG +1.0
                 IF(IOUTSQ(I,K).EQ.IOUTSQ(J,K))THEN
                   TID=TID +1.0
                 END IF
               END IF
30          CONTINUE
            TSCORE(I,J)=(TID/TALIG)*100.0
            TSCORE(J,I)=TALIG
            if(i.ne.j)then
              nent =nent+1
              astarr(nent)=tscore(i,j)
              bstarr(nent)=tscore(j,i)
            end if
20    CONTINUE
C
      CALL STATS(ASTARR,NENT,ASAV,ASSD)
      CALL STATS(BSTARR,NENT,BSAV,BSSD)
      CALL AMESS(IOUT,1,'Lower diagonal = %IDENTITY',0,'-')
      CALL AMESS(IOUT,0,'Upper diagonal = Number of aligned residues',
     -           1,'-')
      CALL WRITG(IOUT,IBSEQ)
      WRITE(IOUT,101)ASAV,ASSD,BSAV,BSSD
C
C --  get the pair scores using dayhoff matrix only over aligned residues
      II = 0
      NENT=0
      DO 21,I=1,IBSEQ
         II = II+1
         DO 21,J=1,II
            TID = 0.0
            TALIG = 0.0
            DO 31,K=1,KPOS
               IF(IOUTSQ(I,K).GT.0.AND.IOUTSQ(J,K).GT.0)THEN
                 TALIG = TALIG +1.0
                 TID = TID + DAY(IOUTSQ(I,K),IOUTSQ(J,K))
               END IF
31          CONTINUE
            TSCORE(I,J)=(TID/TALIG)
            TSCORE(J,I)=TALIG
            if(i.ne.j)then
              nent=nent+1
              astarr(nent) = tscore(i,j)
              bstarr(nent) = tscore(j,i)
            end if
21    CONTINUE
      CALL STATS(ASTARR,NENT,ASAV,ASSD)
      CALL STATS(BSTARR,NENT,BSAV,BSSD)
C
      CALL AMESS(IOUT,1,'Lower diagonal = NAS ',0,'-')
      CALL AMESS(IOUT,0,'Upper diagonal = No of aligned posns',1,'-')
C
      CALL WRITG(IOUT,IBSEQ)
      WRITE(IOUT,101)ASAV,ASSD,BSAV,BSSD
C
      END
C
C**********************************************************************
      SUBROUTINE WRITG(IOUT,IBSEQ)
C---------------------------------------------------------------------
C writes out the current values of TSCORE
C
C----------------------------------------------------------------------
C
      include 'params.blk'
      include 'tester.blk'
      include 'gapmis.blk'
C
      INTEGER I,IBSEQ,J,IOUT
C
C
      WRITE(IOUT,870)(I,I=1,ibseq)
870   FORMAT(20X,20(1x,I5))
C
      DO 10,I=1,ibseq
         WRITE(IOUT,880)I,IDENTS(I),(TSCORE(J,I),J=1,ibseq)
10    CONTINUE
C
880   FORMAT(1X,i5,1x,A10,3X,20F6.1)
C
      END
C
