C***************************************************************
      SUBROUTINE ARRAN(IERR,IORD,INUMB)
C---------------------------------------------------------------
C Reads ordering information from unit IORD and puts the
C sequences,etc  in the order so defined
C
C G. J. Barton (1985)
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'gapmis.blk'
      include 'seqcha.blk'
      include 'intseq.blk'
C
      integer ierr,iord,inumb
C
      INTEGER   I,J,IOS,ITEMP,ENDFIN,IDEST,
     -          TLOC(MAXSEQ)
      REAL      RTEMP
      CHARACTER*3 INCHAR
      CHARACTER*1 CTEMP
C
      i = 0
      j = 0
      ios = 0
      itemp = 0
      idest = 0
C      call initi(tloc,maxseq,0)

C
C     set up tloc
      DO 332,I=1,INUMB
         TLOC(I) = I
332   CONTINUE
C
      I=0
111   CONTINUE
      I=I+1
      READ(IORD,100,END=101)ORD(I),SCR(I),LOCP(I)
C
C - debug
C      write(ierr,100)ord(i),scr(i),locp(i)
      GOTO 111
101   CONTINUE
C
100   FORMAT(1X,I10,F20.2,I10)
      IF(I-1.NE.INUMB)THEN
        CALL AMESS(IERR,1,'Number of entries does not match!',
     -  1,'e')
        CALL AMESS(IERR,1,'SEQFILE HAS '//INCHAR(INUMB),1,' ')
        CALL AMESS(IERR,1,'ORDFILE HAS '//INCHAR(INUMB),1,' ')
        STOP
      END IF
C
C do the transference via ITEMP, CTEMP
C     as pairs
      DO 20,I=1,INUMB
         IDEST=ORD(I)
C        find pointer location
         DO 70,J=1,INUMB
            IF(TLOC(J).EQ.IDEST)THEN
               IDEST = J
            END IF
70       CONTINUE
         IF(IDEST.EQ.I)GOTO 20
C        do the sequences
         DO 30,J=1,MAX(NUMB(I),NUMB(IDEST))
            CTEMP = SEQ(J,IDEST)
            SEQ(J,IDEST) = SEQ(J,I)
            SEQ(J,I) = CTEMP
30       CONTINUE
C        do the lengths
         ITEMP = NUMB(IDEST)
         NUMB(IDEST)=NUMB(I)
         NUMB(I)=ITEMP
C        do the identifiers
         DO 40,J=1,MAX(ENDFIN(IDENTS(IDEST)),ENDFIN(IDENTS(I)))
            CTEMP = IDENTS(IDEST)(J:J)
            IDENTS(IDEST)(J:J) = IDENTS(I)(J:J)
            IDENTS(I)(J:J) = CTEMP
40       CONTINUE
C        do the names
         DO 50,J=1,MAX(ENDFIN(NAMES(IDEST)),ENDFIN(NAMES(I)))
            CTEMP = NAMES(IDEST)(J:J)
            NAMES(IDEST)(J:J) = NAMES(I)(J:J)
            NAMES(I)(J:J) = CTEMP
50       CONTINUE
C        set up tloc
         ITEMP = TLOC(IDEST)
         TLOC(IDEST) = TLOC(I)
         TLOC(I) =ITEMP
C        all done
20    CONTINUE
C
C
      END
C
