C**************************************************************
      SUBROUTINE STATS2(ARRAY,LEN,MEAN,STDEV,SKEW,KURT)
C--------------------------------------------------------------
C Author: Geoff Barton
C 
C Calculates the MEAN and STandard DEViation,SKew and
C kurtosis for the elements
C of real ARRAY length LEN
C Note: denominator is (N-1)
C---------------------------------------------------------------
C
      INTEGER LEN,I
C
      REAL ARRAY(LEN)
      REAL MEAN,STDEV,SUM,SUMSQ,SKEW,KURT,SUMF,SUMQ,T3,SDIFF
C
      SUM=0.0
      SUMSQ=0.0
      MEAN=0.0
      STDEV=0.0
      SKEW=0.0
      KURT=0.0
      SUMQ =0.0
      SUMF =0.0
      SDIFF=0.0
      DO 10,I=1,LEN
         SUM=SUM+ARRAY(I)
         SUMSQ=SUMSQ+ARRAY(I)**2
10    CONTINUE
      MEAN=SUM/LEN
      STDEV=SQRT((SUMSQ-SUM**2/LEN)/(LEN-1))
C
C --  work out skew and kurtosis in an inefficient way..
C     get sum of cubes and fourth powers
      DO 20,I=1,LEN
         SDIFF = ARRAY(I)-MEAN
         T3 = SDIFF*SDIFF*SDIFF
         SUMQ  = SUMQ + T3
         SUMF  = SUMF + (SDIFF * T3)
20    CONTINUE
C
C --
      T3=STDEV*STDEV*STDEV
      SKEW = (SUMQ/LEN)/T3
      KURT = ((SUMF/LEN)/(STDEV*T3))-3
C
      END
C
