C***********************************************************
       SUBROUTINE SCOMP(IBSEQ,KPOS,INUMB)
C-----------------------------------------------------------
C STORES ISEQ ROWWISE
C removes gaps (ie 0's) from the next iseq which is to be
C aligned, then:
C removes coincident gaps from the other sequences
C
C Author: G. J. Barton
C         Copyright 1986 all rights reserved.
C----------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
C
      integer IPOS,KPOS,I,IBSEQ,J,K,INUMB
C
C     this is the value which equals a gap in iseq(*,*)

C
C-----1. gaps from ISEQ(IBSEQ,.))
C
      IPOS=0
C     loop over length of sequence
      DO 10,I=1,KPOS
C        if this is not a gap
         IF(ISEQ(IBSEQ,I).NE.IGAP)THEN
           IPOS=IPOS+1
           ISEQ(IBSEQ,IPOS)=ISEQ(IBSEQ,I)
         END IF
10    CONTINUE
C
C
C-----2. coincident gaps from all other sequences
C
      IPOS=0
C     loop over length of sequences already aligned
      DO 20,I=1,KPOS
C        loop over number of sequences including 0th seq
         DO 30,J=0,INUMB
C           if this sequence is the new one to be aligned
            IF(IBSEQ.EQ.J)GO TO 30
C           if this position is not a gap
            IF(ISEQ(J,I).NE.IGAP)GO TO 35
30       CONTINUE
C
C
C        compress positions that are all gaps
35       CONTINUE
         IF(J.NE.(INUMB+1))THEN
C          if not all positions are gaps then
           IPOS=IPOS+1
C          loop over all pre-aligned sequences and reposition
           DO 40,K=0,INUMB
C             if this is the current sequence being aligned
              IF(IBSEQ.EQ.K)GO TO 40
              ISEQ(K,IPOS)=ISEQ(K,I)
40         CONTINUE
         END IF
20    CONTINUE
C
      KPOS=IPOS
C
      END
C
