C******************************************************************
      subroutine tmult
C------------------------------------------------------------------
C Performs a tree based multiple alignment.  Using the tree defined
C in the TREE_FILE (unit=itree)
C Each pair of clusters to be aligned is read
C from the tree_file in
C turn and aligned.
C
C 11/8/93 - option to weight end gaps added (retree2)
C
C 12/8/93 - modify tree based alignment to use the lookup and looku2
C           tables of frequencies of amino acid types at each position
C           in the alignment.  This also requires a change to the 
C           score.f subroutine
C
C Author:  Geoff Barton
C------------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'conser.blk'
      include 'tester.blk'
      include 'param2.blk'
      include 'probas.blk'
C
      integer nca,ncb
C     number of sequences in cluster a and cluster b currently aligning
C
      integer aclust(maxseq),bclust(maxseq)
C     arrays holding info on the sequences in each current cluster
C
C --  
      common /itrees/nca,ncb,aclust,bclust
C
      integer i,j,kpos,aloc,bloc
C
      kpos = 0
1     continue
C
C 6/2/92:  put in checking for overflow of alignment length
      if(kpos .gt. maxdim-10)then
         call amess(iout,1,'ALIGNMENT DUMPED!!!!!!!!!!!!!!!',1,'*')
         call amess(iout,1,'LENGTH EXCEEDS MAXIMUM ALLOWED',1,'*')
         call amess(iout,1,'Try: larger gap_penalty or',0,' ')
         call amess(iout,0,'     shorter sequences(!)',0,' ')
         call amess(iout,0,'Try: running in single order mode',0,' ')
         call amess(iout,0,'     check integrity of sequences',1,'*')
         stop
      end if
C
C      write(6,6098)nca,ncb,inumb
C6098  format(1x,'nca ',i4,'ncb ',i4,'inumb ',i4)
C
      if((nca+ncb).eq.inumb)then
C --     all sequences have been aligned
         call konbak(kpos,inumb)
         if(test)then
            call gcheck(inumb,kpos,6)
         end if
         if(pfull)then
            call write6(kpos,inumb,comnd(15),comnd(16))
         end if
         if(ppret)call pretty(iout,nhoriz,inumb,kpos)
         if(test) call wcheck(iout,inumb,kpos)
         return
      end if
C
C --  read next cluster
      read(itree,50,err=500,end=501)nca
      read(itree,50,err=500,end=501)(aclust(i),i=1,nca)
      read(itree,50,err=500,end=501)ncb
      read(itree,50,err=500,end=501)(bclust(i),i=1,ncb) 
50    format(1x,20i5)
C
C - debug      
C      write(ierr,50)nca
C      write(ierr,50)(aclust(i),i=1,nca)
C      write(ierr,50)ncb
C      write(ierr,50)(bclust(i),i=1,ncb) 
C
C -- build frequency tables for the pair of groups of sequences
C    GJB - 12/8/93
      call bfreq(numb(aclust(1)),numb(bclust(1)))
C
C --  run recurs on the current pair of clusters
      if(comnd(205))then
C        weight the end gaps
         call retree2(numb(aclust(1)),numb(bclust(1)),gap,match,
     -            aloc,bloc)
      else
         call retree(numb(aclust(1)),numb(bclust(1)),gap,match,
     -            aloc,bloc)
      end if
C
C --  align the current pair of clusters.
      call altree(numb(aclust(1)),numb(bclust(1)),aloc,bloc,kpos)
C      write(6,679)numb(aclust(1)),numb(bclust(1)),kpos
C679   format(1x,'numb(aclust(1)) ',i5,'numb(bclust(1)) ',i5,
C     -          'kpos ',i5)
C
C --  update the lengths of the aligned sequences
      do 112,i=1,nca
         numb(aclust(i))=kpos
112   continue
      do 113, j=1,ncb
         numb(bclust(j))=kpos
113   continue
C
C --  copy the ioutsq's to the iseq's
      do 114,i=1,kpos
         do 115,j=1,nca
            iseq(aclust(j),i)=ioutsq(aclust(j),i)
115      continue
         do 116,j=1,ncb
            iseq(bclust(j),i)=ioutsq(bclust(j),i)
116      continue
114   continue
C
C -- go back for the next cluster
      goto 1
C
500   continue
      call amess(ierr,1,'Error reading from tree_file',1,'e')
      stop
501   continue
      call amess(ierr,1,'Premature end to tree_file',1,'e')
      stop
C
      end

C*********************************************************************
      subroutine bfreq(lena,lenb)
C---------------------------------------------------------------------
C Builds frequency tables in lookup and looku2 for the sequences
C identified in aclust and bclust respectively
C

      include 'params.blk'
      include 'intseq.blk'
      include 'dayhof.blk'

      integer i,lena,lenb
      
      do 10, i=1,lena
C -      set the row of lookup to 0.0
         do 20, j=0,23
            lookup(i,j) = 0.0
20       continue
C -      build frequencies for this row
         do 30, j=1,nca
            lookup(i,iseq(aclust(j))) = lookup(i,iseq(aclust(j))) + 1.0
30       continue
10    continue


      do 40, i=1,lenb
C -      set the row of looku2 to 0.0
         do 50, j=0,23
            looku2(i,j) = 0.0
50       continue
C -      build frequencies for this row
         do 60, j=1,ncb
            looku2(i,jseq(bclust(j))) = looku2(i,jseq(bclust(j))) + 1.0
60       continue
40    continue

      end

