C*******************************************************************
      subroutine gjplot(simmat,n,nentry,ident)
C-------------------------------------------------------------------
C Author: Geoff Barton
C
C subroutine to plot dendrograms (called from CLUST)
C This routine uses produces a plot using ascii characters
C
C Note, there are undoubtedly redundant variables passed in common
C to this routine.  This is the result of splitting a larger program
C-------------------------------------------------------------------
C
C include file of virtually everything
C
      include 'clust.blk'
C
      integer iwtype
      logical error
      character*80 justl
C
      real tic,xtinc,xaxx(2),yaxy(2)
      character*7 rechar
      integer ik,ij
C
C --plotting array
      character*1 cplot(maclus,malin)
      integer mclus,mlin,iwidth
      mclus = maclus
      mlin = malin

C
C --------------------------------------------------------------
C this section could be proceduralised as it is solely concerned
C with plotting th result of the cluster analysis by using
C a lineprinter or similar device
C---------------------------------------------------------------
C
C -- blank the output array
      call initc(cplot,mclus*mlin,' ')
C
C --  Open file for plot output
      call qmess(6,5,1,'Enter plot filename ',line)
      if(error)then
        call amess(6,1,'Error reading command',1,' ')
        stop
      endif
      write(6,*)line
      open(unit=98,status='new',
     -file=line(:endfin(line)),iostat=ios)
      if(ios.ne.0)then
        call amess(6,1,'Error opening file',1,'e')
        return
      end if
C
C --  ask nicely for the title and xaxis title and text mag
      CALL QMESS(6,5,1,'Please enter the axis title :',xtit)
      CALL QMESS(6,5,1,'Please enter the plot title :',tit)
C
      call qmess(6,5,1,'Enter page width required :',line)
      call intcom(line,iwidth,error)
      write(6,601)iwidth
      if(iwidth.gt.malin)then
         call amess(6,1,'Error max width exceeded',1,'e')
         return
      end if
601   format(1x,'Page width: ',i5)
C
C --set limit for x value (ie leave space for the labels and scores)
      write(6,*)'iwidth',iwidth
      xlim = iwidth - 20
      write(6,*)'xlim',xlim
C
      XRANGE = CSCORE(1)-CSCORE(NCLUST)
      write(6,*)'cscore(1)',cscore(1),'cscore(nclust)',cscore(nclust)
      write(6,*)'xrange',xrange
C
      xscale = xlim/xrange
      write(6,*)'xscale',xscale
      xmin = cscore(nclust)
C
C --write out the X value for every 10 units
      do 3401,i=1,xlim+1,10
         call schar(1,line)
         write(line(i:),3402)i/xscale + xmin
3402     format('|',f8.2)
         write(98,3403)(line(j:j),j=1,endfin(line))
3403     format(1x,300a1)
3401  continue
C
C --  draw the xaxis from min cluster value to max
C      call gselnt(2)
C      xaxx(1)=cscore(nclust)
C      xaxx(2)=cscore(1)
C      yaxy(1)=10.0
C      yaxy(2)=10.0
C      call gpl(2,xaxx,yaxy)
C
C --  draw the tick marks and numbers
C      yaxy(1)=9.0
C      yaxy(2)=10.0
C
C --  loop over the number of clusters and label each cluster with
C     its score
C      ik=1
C      do 567,i=1,nclust
C         if(ik.eq.9)then
C            yaxy(1)=10.0
C            ik = 1
C         end if
C         tic = cscore(i)
C         xaxx(1)=tic
C         xaxx(2)=tic
C         call gpl(2,xaxx,yaxy)
C         call gtx(tic,yaxy(1)-1.0,rechar(tic,2))
C         yaxy(1) = yaxy(1)-1.0
C         ik = ik + 1
C567   continue
C
C --  write the xaxis title in the center of the axis
C      call gselnt(4)
C      call gstxal(2,0)
C      call gtx((cscore(1)-cscore(nclust))/2.0,5.0,
C     -         xtit(:endfin(xtit)))
CC
CC --  write the picture title
C      call gselnt(3)
C      call gtx((cscore(1)-cscore(nclust))/2.0,5.0,
C     -          tit(:endfin(tit)))
C
C --
C      CALL NEWPIC
C
C --  set up and draw Xaxis ( no yaxis is required)
C      IF(VERT)THEN
C         CALL TEXTMG(TMAG)
C         CALL YAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C         CALL TEXTMG(1.0)
C      ELSE
C         CALL XAXIS7(CSCORE(NCLUST)-ABIT,
C     -            CSCORE(1)+ABIT,0.0,XTIT(1:ENDFIN(XTIT)))
C      END IF
C
C --  Set up a pointer array to the positions of elements to
C     be plotted
      DO 91,I=1,NCTOT(NCLUST)
         POINT(CTOTAL(NCLUST,I)) = I
91    CONTINUE
C
C --  write the identifying numbers down the rhs of plot
C
         DO 92,I=1,NCTOT(NCLUST)
            write(line,9981)ctotal(nclust,i),
     -                      ident(ctotal(nclust,i))
C -- 11/9/91 change a10 to a20 for longer idents
9981        format(1x,i4,1x,a20)
            ij = 0
C -- 11/9/91 change 20 to 30 for longer idents
            do 334,ik=xlim + 1, xlim + 30
               ij = ij + 1
               if(ik.gt.iwidth)then
                  goto 92
               end if
               cplot(i,ik) = line(ij:ij)
334          continue
92       CONTINUE
C --  start drawing the cluster diagram by going down the list
C     stored in CPAIRS
      DO 93,I=1,NCLUST
C        if we are joining a cluster then find the mean Y position
C        otherwise set the value to the y position of the element
C        do the first of the pair
         IF(CPAIRS(1,I).GT.CADD)THEN
            TINDEX = CPAIRS(1,I)-CADD
            TOT = 0.0
            DO 94,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
94          CONTINUE
            Y(1) = TOT/NCTOT(TINDEX)
            X(1) = int(xscale*(CSCORE(TINDEX)-xmin))
            X(2) = int(xscale*(CSCORE(I)-xmin))
         ELSE
            Y(1) = POINT(cpairs(1,i))
            X(1) = int(xscale*(CSCORE(1)-xmin)) + 2
            X(2) = int(xscale*(CSCORE(I)-xmin))
         END IF
C
C --     do the second of the pair
         IF(CPAIRS(2,I).GT.CADD)THEN
            TINDEX = CPAIRS(2,I)-CADD
            TOT = 0.0
            DO 95,J=1,NCTOT(TINDEX)
               TOT = TOT + POINT(CTOTAL(TINDEX,J))
95          CONTINUE
            Y(4) = int(TOT/NCTOT(TINDEX))
            X(4) = int(xscale*(CSCORE(TINDEX)-xmin))
          ELSE
            Y(4) = POINT(cpairs(2,i))
            X(4) = int(xscale*(CSCORE(1)-xmin)) + 2
          END IF
C
C --      now call jclust to join the points up
          CALL JCLUST(X,Y,4,cplot,mclus,mlin)
93    CONTINUE
C
C -- write out the plot
      do 456,i=1,nctot(nclust)
         write(98,9978)(cplot(i,j),j=1,iwidth)
456   continue
9978  format(1x,1000a1)
C
C -- write out the scores
C      do 9986,i=1,nctot(nclust)
C         write(98,997)cscore(i)
C9986  continue
C997   format(f8.2)
      close(98)
      END
C
C**************************************************************
      SUBROUTINE JCLUST(X,Y,N,cplot,maclus,malin)
C--------------------------------------------------------------
C
      INTEGER N
      integer x(n),y(n)
      integer maclus,malin
      character*1 cplot(maclus,malin)

C
C
      Y(2) = Y(1)
      Y(3) = Y(4)
      X(3) = X(2)
C
      call lplot(n,x,y,cplot,maclus,malin)
C
      END
C
C************************************************************
      subroutine lplot(n,x,y,cplot,maclus,malin)
C------------------------------------------------------------
      INTEGER N
      integer x(n),y(n)
      integer maclus,malin,i,k,ip1
      character*1 cplot(maclus,malin)
C
C --loose the possibility of plotting values <1
      do 33,i=1,4
         if(x(i).lt.1)then
            x(i) = 1
         end if
33    continue
C
      do 10,i=1,N
         ip1 = i + 1
         if(ip1.gt.N)then
            goto 1000
         end if
         if(y(i).eq.y(ip1))then
            if(x(i).ge.x(ip1))then
               do 20,k=x(i),x(ip1),-1
                  cplot(y(i),k)='-'
20             continue
            else
               do 30,k=x(i),x(ip1),1
                  cplot(y(i),k)='-'
30             continue
            end if
          else if(x(i).eq.x(ip1))then
            if(y(i).ge.y(ip1))then
               do 40,k=y(i),y(ip1),-1
                  cplot(k,x(i)) = '|'
40             continue
            else
               do 50,k=y(i),y(ip1),1
                  cplot(k,x(i)) = '|'
50             continue
            end if
          end if
10      continue
C
1000    continue
        do 60,i=1,n
           cplot(y(i),x(i)) = '+'
60      continue
C
        end
C
      
