/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK is Copyright (1995) R. B. Russell and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include "rdssp.h"
#include "rbr_newlib.h"
#define AA "ARNDCQEGHILKMFPSTWYVBZXc"
#define SS "-STGHIBE"
#define AA2 "ABCDEFGHI_KLMN_PQRST_VWXYZ________c"
struct protein {
	char *file;		/* File name */
	char *label;		/* Label name */
	float R[3][3];  	/* Transformation */
	float V[3];		/*      "        */
	char *seq;		/* Sequence */
	struct brookn *br;	/* Brookhaven numbering scheme */
	char *ksseq;		/* KS summary */
	struct range ks;	/* Kabsch and Sanders numbering */
	char *start, *end;      /* Brookhaven numbering */
	char chain;		/* chain identifier */
	int num;		/* number of residues */
	};
struct residue {
	char resname[6];  	/* 3 letter code */
	char aa;		/* 1 letter code */
	struct brookn resnum;   /* Brookhaven numbering */
	int ksnum;		/* KS numbering */
	int num;		/* Number of atoms */
	float **atoms;		/* Coordinates of each atom */
	char **atname;		/* Atom name (4 chars) */
	int *atnum;		/* Atom number */
	float *occ;		/* Atom Occupancy */
	float *B;		/* Temperature factor */
	int contacts;		/* Number of contacts this residue makes */
	int sidecont;		/* Number of contacts made by the side chain only */
	int hyd;		/* Number of hydrophobic contacts (C-C) made */
	int sidehyd;		/* Number of side-chain hydrophobic contacts */
	int elec;		/* Number of electrostatic contacts */
	int sideelec;		/* Number of electrostatic contacts made by the side chain only */
	int polar;		/* Number of half-electrostaic contacts made */
	int sidepolar;		/* Use your intutition */
	int nrc;		/* Number of Residues in Contact with this residue */
	int med_nrc;		/* Number of Residues farther apart than 10 (less then 20) residues that are in contact */
	int long_nrc;		/* Number of Residues farther apart than 20 residues that are in contact */
	int acc;		/* Accessible surface area */
	char kssum;		/* Kabsch and Sanders Summary (letter) */
	int j;			/* number of atom spaces allocated */
	int s_s;		/* is this a disulphide? */
	};
struct summation {
	long int accsum;	/* accessibility sum */
	long int accsq;		/* sum of acc*acc */
	long int consum;	/* contacts sum */
	long int consq;		/* sum of contacts*contacts */
	long int elec;		/* electrostatic contacts sum */
	long int elecsq;	/* sum of elec*elec */
	long int scsum;    	/* side chain contacts sum */
	long int scsq;		/* sum of sidecont*sidecont */
	long int secsum;	/* side chain electrostatic sum */
	long int secsq;		/* sum of the square of the above */
	long int total;		/* total number */
	};
struct parameters{
	float CC_DISTANCE;	/* Ca - Ca initial check */
	float AA_DISTANCE;	/* Value added to sum of VDW radii */
	float HYDROPHOBIC;	/* Maximum C - C separation considered to be a hydrophobic contact */
	float HBOND;		/* Hydrogen bond */
	float SQHBOND;		
	float DISUL;		/* Disulphide bond */
	float SQDISUL;
	float TOOCLOSE;		/* Too close for contacts other than H-bonds or disulphides */
	float SQTOOCLOSE;
	float MUCHTOOCLOSE;	/* Too close for H-bonds or disulphides */
	float SQMUCHTOOCLOSE;
	int WATERS;
	int ACEFOR;
	char VDW_FILE[200]; 	/* file with VDW radii */
	int FORCE;		/* force all contacts to be considered regardless of missing atoms */
	};
struct radii{
	char atom;
	float radius;
	};
