/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was written by Asim S. Siddiqui

 The WORK is Copyright (1995) A. S. Siddiqui and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <asd_structs.h>
#include <asd_get_params.h>

extern Asd_Parameters params;

/* Reads in paramters from a specified file
 *
 * for example
 *
 *  WINDOW 3   		Window length of three
 *  THRESTATE yes	Use three states only
 *
 * N.B. Comments may only be one line long (no return characters)
 */

asd_get_params(FILE *fp)
{
    int i,BOOL;
    char c;
    char *parm;		/* name of following dimension */
    char *dim;		/* dimension */

   /* set default parameter values
    *  these are changed if a paramter file is specified */

    parm = (char*)malloc(200*sizeof(char));
    dim  = (char*)malloc(200*sizeof(char));

    while(fscanf(fp,"%s%s",parm,dim) != (int)EOF){
	BOOL=(dim[0]=='y' || dim[0]=='Y' || dim[0]=='1' || dim[0]=='t' || dim[0]=='T');
	for(i=0; i<strlen(parm); ++i)
	   parm[i]=RBR_ltou(parm[i]); /* convert to upper case */
	/* enables one to write '1', 'YES', 'Yes', 'yes', 'BOOL', 'True' or 'true' to 
	 *  set any boolean variable to one */
if(strcmp(parm,"MIN_DOMAIN_SIZE")==0) {
            sscanf(dim,"%d",&params.MIN_DOMAIN_SIZE);
        } else if(strcmp(parm,"MIN_SEGMENT_SIZE_END")==0) {
            sscanf(dim,"%d",&params.MIN_SEGMENT_SIZE_END);
        } else if(strcmp(parm,"MIN_SEGMENT_SIZE_MID")==0) {
            sscanf(dim,"%d",&params.MIN_SEGMENT_SIZE_MID);
        } else if(strcmp(parm,"MIN_DOUBLE_SPLIT")==0) {
            sscanf(dim,"%d",&params.MIN_DOUBLE_SPLIT);
        } else if(strcmp(parm,"MIN_NO_CONTACT_CUTOFF_MID")==0) {
            sscanf(dim,"%d",&params.MIN_NO_CONTACT_CUTOFF_MID);
        } else if(strcmp(parm,"MIN_NO_CONTACT_CUTOFF_END")==0) {
            sscanf(dim,"%d",&params.MIN_NO_CONTACT_CUTOFF_END);
        } else if(strcmp(parm,"E_WEIGHT")==0) {
            sscanf(dim,"%f",&params.E_WEIGHT);
        } else if(strcmp(parm,"MAX_ALLOWABLE_GLOB")==0) {
            sscanf(dim,"%f",&params.MAX_ALLOWABLE_GLOB);
        } else if(strcmp(parm,"MIN_PEAK_SS_ONLY_C")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_SS_ONLY_C);
        } else if(strcmp(parm,"MIN_PEAK_C")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_C);
        } else if(strcmp(parm,"MIN_PEAK_SS_ONLY_DC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_SS_ONLY_DC);
        } else if(strcmp(parm,"MIN_PEAK_DC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_DC);
        } else if(strcmp(parm,"MIN_PEAK_SS_ONLY_MC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_SS_ONLY_MC);
        } else if(strcmp(parm,"MIN_PEAK_MC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_MC);
        } else if(strcmp(parm,"MIN_PEAK_BLO_C")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_BLO_C);
        } else if(strcmp(parm,"MIN_PEAK_SS_ONLY_BLO_C")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_SS_ONLY_BLO_C);
        } else if(strcmp(parm,"MIN_PEAK_BLO_DC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_BLO_DC);
        } else if(strcmp(parm,"MIN_PEAK_SS_ONLY_BLO_DC")==0) {
            sscanf(dim,"%f",&params.MIN_PEAK_SS_ONLY_BLO_DC);
        } else if(strcmp(parm,"MIN_SS_PER")==0) {
            sscanf(dim,"%f",&params.MIN_SS_PER);
        } else if(strcmp(parm,"MIN_HELIX_LENGTH")==0) {
            sscanf(dim,"%d",&params.MIN_HELIX_LENGTH);
        } else if(strcmp(parm,"HELIX_RAMP")==0) {
            sscanf(dim,"%d",&params.HELIX_RAMP);
        } else if(strcmp(parm,"HELIX_REDUCE_C_DENS")==0) {
            sscanf(dim,"%f",&params.HELIX_REDUCE_C_DENS);
        } else if(strcmp(parm,"INCREMENT_DIVIDER")==0) {
            sscanf(dim,"%d",&params.INCREMENT_DIVIDER);
        } else {
    	    printf("Unrecognised Dimension Command\n");
	    printf("%s %s\n",parm,dim);
            exit(-1);
	} /*if*/
	while((c=getc(fp))!=(char)EOF && c!='\n'); /* read the end of the line, allows for comments */
	if(c==(char)EOF) break;
    }
    free(parm); free(dim); 
}
