/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Geoffrey J. Barton


 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
Include file of the structures and function
definitions used in the rdssp routines - interface to the
Kabsch and Sander library of files 
G. J. Barton 1991
*/

#ifndef HAVE_RDSSP_H
#define HAVE_RDSSP_H



struct brookn {	/* structure to represent brookhaven residue numbers */
    int n;	/* numerical part of number */
    char cid;	/* chain identifier */
    char in;	/* insertion code */
};

struct range{ /* general purpose range structure */
    int s;  /* start of range */
    int e;  /* end of range */
}; 

struct brange{ /* range specified in brookhaven numbers */
    struct brookn s;
    struct brookn e;
};

struct hbond{	    /* hydrogen bond structure */
    int pos;	    /*offset of hbond partner */
    float energy;   /*energy of hbond */
};

struct ps{
    float phi;	    /* phi psi angles */
    float psi;
};

struct threed{
    float x;	/* x,y,z coordinates */
    float y;
    float z;
};

struct br{
    int one;	/* bridge partners - absolute residue numbers */
    int two;	/* NOT offsets */
};

/* 
Basic get_ functions - These return pointers to suitable
arrays containing the complete information from the file - e.g.
the complete secondary structure defintion for all chains of a protein
as stored in the DSSP .ALL file
*/
char *get_aa(char *fname, int *count);
char *get_ss(char *fname,int *count);
int *get_n(char *fname,int *count);
struct brookn *get_bn(char *fname,int *count);
int *get_acc(char *fname,int *count);
struct hbond *get_hb(char *fname,int *count,char *type);
float *get_tco(char *fname,int *count);
float *get_kappa(char *fname,int *count);
float *get_alpha(char *fname,int *count);
struct ps *get_phipsi(char *fname,int *count);
struct threed *get_ca(char *fname,int *count);
struct br *get_bridge(char *fname,int *count);
char *get_sheet(char *fname,int *count);
char *strbit(int start,int end,char *s);
struct range *i_fields(char *line);

/* 
Utility functions:  chain_range returns the start and end residue numbers
for the chosen chain ID.
Function chain_list() returns a character array containing all the chain ID's
present in the file - thus, these two routines together with the nget_() series
of functions could be used to extract 
information on all chains from any given DSSP .ALL file.
*/

struct range *chain_range(char *fname,int *count,char cid);
char *chain_list(char *fname,int *count);
char *disul_s(char *aa,int *count);   /* convert lowercase to 'C' */

/* 
The nget series - as for get_() functions, only include two
extra arguments that specify the  first and last residue to select.
Residue numbering is by the unique DSSP number (e.g. as returned by get_n())
rather than brookhaven numbers.
The functions return pointers to structures containing just the selected bits.
*/
char *nget_aa(char *fname,int *count,int s,int e);
struct brookn *nget_bn(char *fname,int *count,int s,int e);
int *nget_acc(char *fname,int  *count,int s,int e);
struct hbond *nget_hb(char *fname,int *count,char  *type,int s,int e);
float *nget_tco(char *fname,int *count,int s,int e);
float *nget_kappa(char *fname,int *count,int s,int e);
float *nget_alpha(char *fname,int *count,int s,int e);
struct ps *nget_phipsi(char *fname,int *count,int s,int e);
struct threed *nget_ca(char *fname,int *count,int s,int e);
struct br *nget_bridge(char *fname,int *count,int s,int e);
char *nget_sheet(char *fname,int *count,int s,int e);

int check_dssp(char *fname);
char *dblank_ss(char *aa, int *count);


#endif   /* HAVE_RDSSP_H */

