/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *   ase_error.c
 * SccsId
 *   %W%   %U%   %E%
 * Puprose:
 *   To provide error handling routines
 */

#include <stdio.h>
#include <ase_error.h>

/*
 * name
 *     ase_error_fatal
 * purpose:
 *     called in case of fatal error
 */
void
ase_error_fatal(char *module, char *message)
{
    fprintf(stderr, "FATAL ERROR : %s\n", module);
    fprintf(stderr, "FATAL ERROR : %s\n", message);
    exit(-1);
} /*ase_error_fatal*/

/*
 * name
 *     ase_error_warn
 * purpose:
 *     called in case of non fatal error
 */
void
ase_error_warn(char *message)
{
    fprintf(stdout, "WARNING : %s\n", message);
} /*ase_error_fatal*/

