/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/* $Id: asm_mop.c,v 1.6 2004/09/10 14:39:03 geoff Exp $ */

/*
 * Title
 *   asm_mop.c
 * SccsId
 *   %W%   %U%   %E%
 * Puprose:
 *   To provide memory handling routines
 */

#include <stdio.h>

#include <ase_error.h>
#include <asm_mop.h>

/*
 * name
 *     asm_malloc
 * purpose:
 *     allocate memory as required
 */
void *
asm_malloc(size_t size)
{
    void *ptr;
    ptr = malloc(size);

    if (ptr == NULL) {
        ase_error_fatal("as_realloc", "out of memory");
    } /*if*/

    return (ptr);
} /*asm_realloc*/

/*
 * name
 *     asm_realloc
 * purpose:
 *     allocate/reallocate memory as required
 */
void *
asm_realloc(void *ptr, size_t size)
{
    if (ptr == NULL) {
        ptr = malloc(size);
    } else {
	/* Don't call realloc with a size value of zero as the result
	 * is not specified (i.e. it can be NULL). */
	if (size != 0){
	    ptr = realloc(ptr, size);
	}
    } /*if*/
    if (ptr == NULL) {
        ase_error_fatal("as_realloc", "out of memory");
    } /*if*/
    return(ptr);
} /*asm_realloc*/
