/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell


 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/* $Id: a3to1.c,v 1.4 2004/09/10 14:39:17 geoff Exp $ */

#include <stdio.h>


#define RBR_a3to1_acids3 "ALA ARG ASN ASP CYS GLN GLU GLY HIS ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL ASX GLX UNK CYH HET"
#define RBR_a3to1_acids1 "ARNDCQEGHILKMFPSTWYVBZXch"

/* Converts three letter amino acid code to one letter
 *  amino acid code 
 * Note: CYS refers to cystine, CYH refers to cysteine */

char RBR_a3to1(a3) 
char *a3;
{
	int i;
	char new;

	new='X';
	for(i=0;i<strlen(RBR_a3to1_acids1); i++) {
	   if (strncmp(&RBR_a3to1_acids3[i*4],a3,3) == 0) 
	      new=(char)RBR_a3to1_acids1[i];
	}   /* end of for  */

	return(new);
} /* end of function */
