/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *    asd_mds_utils1.h
 * Author
 *    Asim Siddiqui
 * SccsId
 *    %W%   %U%   %E%
 */

#ifndef HAVE_ASD_MDS_UTILS1_H
#define HAVE_ASD_MDS_UTILS1_H

#include <rdssp.h>
#include <asd_structs.h>
#include <local.h>

int
asd_calc_res_from_scratch_m(Asd_Contact_Info **contact_info,
                            Asd_Contact_Info **contact_rev_info,
                            Asd_Domain *d_to_split, Asd_Domain *max_domain_m,
                            Asd_Seg_Cont *s_conts, bool_t ss_only, char *ss,
                            int start_chain, int end_chain,
                            int s1_s, int s1_e, int s2_s, int s2_e,
                            struct brookn *bn, Asd_Contact_List *c_list);

int
asd_calc_res_given_m(Asd_Contact_Info **contact_info,
                     Asd_Contact_Info **contact_rev_info,
                     Asd_Domain *d_to_split, Asd_Domain *max_domain_m,
                     Asd_Seg_Cont *s_conts, bool_t ss_only, char *ss,
                     int start_chain, int end_chain,
                     int s1_sn, int s1_en, int s2_sn, int s2_en,
                     int s1_s,  int s1_e,  int s2_s,  int s2_e,
                     int total_contacts, struct brookn *bn,
                     Asd_Contact_List *c_list, int increment);

#endif /*HAVE_ASD_MDS_UTILS1_H*/
