/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *    ass_stamp_utils
 * Purpose
 *    header file for ass_stamp_utils
 * SccsId
 *    %W%   %U%   %U%
 */

#ifndef HAVE_ASS_STAMP_UTILS_H
#define HAVE_ASS_STAMP_UTILS_H

#include <rbr_domain.h>
#include <rdssp.h>
#include <stdio.h>
#include <asd_structs.h>

struct domain_loc *
ass_read_stamp(char *stamp_file_name, int *num_domains); 

char *
ass_write_domain_string_with_bit(Asd_Domain *domain, Asd_Domain *bit,
                                 struct brookn *bn);

char *
ass_write_domain_string(Asd_Domain *domain, struct brookn *bn);

void
ass_set_code(char *code_i);

void
ass_set_pdb_file(char *pdb_file_i);

void
asd_print_domains(Asd_Domain_List *d_list, struct brookn *bn, FILE *fptr,
                  FILE *rasmol_fptr, char cid);

void
asd_d_comments(int comm_num, Asd_Domain *domain, struct brookn *bn);

void
ass_bit_comments(Asd_Domain *bit, Asd_Domain *domain, struct brookn *bn);

void
ass_glob_comments(int comm_num, Asd_Domain *domain, struct brookn *bn);

char *
ass_write_domain_defn_with_all(Asd_Domain_List *d_list, int d_num,
                               struct brookn *bn);

#endif /*HAVE_ASS_STAMP_UTILS_H*/
