/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Robert B. Russell

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <rdssp.h>
#include <rbr_newlib.h>
#include <rbr_domain.h>

struct parameters { 
  float INTERCEPT;
  float GRADIENT;
  int   LARGE;
  float LARGER_LIMIT;
  float MAX;
  int   DIST_POWER;
  int   PRECISION;
  int   MAX_SEQ_LEN;
  float MAX_MISS_BHBOND;
  float HBOND_MIN_ENERGY;
  float A;
  float B;
};

float rbrg_isqdist();
int *rbrg_c_of_m();
float rbrg_r_of_gyration();
struct parameters rbrg_getpars();
