/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was written by Asim S. Siddiqui

 The WORK is Copyright (1995) A. S. Siddiqui and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Name
 *   asd_mds_utils.c
 * Purpose
 *   to provide a set of utility routines for the make_domans routines
 * Author
 *   Asim Siddiqui
 * SccsId
 *   %W%   %U%   %E%
 */

#include <rdssp.h>
#include <asd_structs.h>
#include <asm_mop.h>
#include <ase_error.h>
#include <local.h>
#include <asd_make_domains.h>
#include <asd_make_domains_2.h>
#include <asd_mds_utils1.h>
#include <asd_utils.h>
#include <asd_value.h>

extern Asd_Parameters params;

int sc_corr;                   /* whether segment c is correlated to another
                                * left over part                             */
Asd_Domain d_sc_corr;     /* sc correlated domain                       */
Asd_Seg_Cont sc_seg_info; /* segement c and correlated part info        */

/*
 * Name
 *   asd_calc_res_from_scratch_m
 * Purpose
 *   calculate the contacts form scratch for a multi cut senario
 *   ASSUMES s1 is before s2
 */
int
asd_calc_res_from_scratch_m(Asd_Contact_Info **c1,
                            Asd_Contact_Info **c2,
                            Asd_Domain *d_to_split, Asd_Domain *max_domain_m,
                            Asd_Seg_Cont *s_conts, bool_t ss_only, char *ss,
                            int start_chain, int end_chain,
                            int s1_s, int s1_e, int s2_s, int s2_e,
                            struct brookn *bn, Asd_Contact_List *c_list)
{
    int i;                      /* loop counter                          */
    int j;                      /* loop counter                          */
    int size1;                  /* size of segment                       */
    int size2;                  /* size of segment                       */
    int size3;                  /* size of segment                       */
    float value;                /* temporary value                       */
    int s1_extra;               /* s1 contacts to further s2             */
    int s1_sht_extra;           /* s1 sheet contacts to further s2       */
    int sb_extra;               /* sb contacts with s2                   */
    int sb1_extra;              /* sb contacts with s2                   */
    int sb_int;                 /* internal sb contacts                  */
    int sb_sht_extra;           /* sb sheet contacts with s2             */
    int sb1_sht_extra;          /* sb sheet contacts with s2             */
    int num_contacts;           /* number of contacts for that item      */
    Asd_Contact_Info **cf1_ptr; /* temporary pointer to forward contacts */
    Asd_Contact_Info *cf2_ptr;  /* temporary pointer to forward contacts */
    Asd_Contact_Info **cr1_ptr; /* temporary pointer to reverse contacts */
    Asd_Contact_Info *cr2_ptr;  /* temporary pointer to reverse contacts */
    Asd_Contact_Info **cbf1_ptr; /* temporary pointer to forward contacts */
    Asd_Contact_Info *cbf2_ptr;  /* temporary pointer to forward contacts */
    Asd_Contact_Info **cbr1_ptr; /* temporary pointer to reverse contacts */
    Asd_Domain d_l_over[3];     /* domain left over                      */
    Asd_Domain *d_left_over;    /* domain left over                      */
    Asd_Contact_Info **contact_info;  /* beta sheet list                 */
    Asd_Contact_Info **contact_rev_info;  /* reverse beta sheet list     */
    Asd_Contact_Info **beta_l;  /* beta sheet list                       */
    Asd_Contact_Info **rev_beta_l;  /* reverse beta sheet list           */

    contact_info = c_list->cl;
    contact_rev_info = c_list->rcl;
    beta_l = c_list->bl;
    rev_beta_l = c_list->rbl;
    s_conts->s1_int = 0;
    s_conts->s2_int = 0;
    s_conts->s1_ext = 0;
    s_conts->s2_ext = 0;
    s_conts->s1_s2_cont = 0;
    s_conts->s1_sht_int = 0;
    s_conts->s2_sht_int = 0;
    s_conts->s1_sht_ext = 0;
    s_conts->s2_sht_ext = 0;
    s_conts->s1_s2_sht_cont = 0;
    sb_int = 0;
    s1_extra = 0;
    s1_sht_extra = 0;
    sb_extra = 0;
    sb_sht_extra = 0;
    sb1_extra = 0;
    sb1_sht_extra = 0;
    sc_corr = 0;
    d_left_over = d_l_over;

/* first scan s1 to work out s1_int s1_ext s1_sht_ext s1_sht_int */
    i = s1_s;
    cf1_ptr = (contact_info + s1_s);
    cr1_ptr = (contact_rev_info + s1_s);
    cbf1_ptr = (beta_l + s1_s);
    cbr1_ptr = (rev_beta_l + s1_s);

    while (i <= s1_e) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s1_s && (*cf2_ptr).res_num <= s1_e) {
                    (s_conts->s1_int)++;
                } else {
                    (s_conts->s1_ext)++;
                    if ((*cf2_ptr).res_num >= s2_s) {
                        s1_extra++;
                    } /*if*/
                    if ((*cf2_ptr).res_num >= s2_s &&
                        (*cf2_ptr).res_num <= s2_e) {
                        (s_conts->s1_s2_cont)++;
                    } /*if*/
                    if ((*cf2_ptr).res_num < s2_s &&
                        (*cf2_ptr).res_num > s1_e) {
                        sb1_extra++;
                    } /*if*/
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* now do forward beta sheet contacts */
            cbf2_ptr = *cbf1_ptr;
            num_contacts = (*cbf2_ptr).res_num;
            cbf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cbf2_ptr).res_num >= s1_s &&
                    (*cbf2_ptr).res_num <= s1_e) {
                    (s_conts->s1_sht_int)++;
                } else {
                    (s_conts->s1_sht_ext)++;
                    if ((*cbf2_ptr).res_num >= s2_s) {
                        s1_sht_extra++;
                    } /*if*/
                    if ((*cbf2_ptr).res_num >= s2_s &&
                        (*cbf2_ptr).res_num <= s2_e) {
                        (s_conts->s1_s2_sht_cont)++;
                    } /*if*/
                    if ((*cbf2_ptr).res_num < s2_s &&
                        (*cbf2_ptr).res_num > s1_e) {
                        sb1_sht_extra++;
                    } /*if*/
                } /*if*/
                j++;
                cbf2_ptr++;
            } /*while*/
/* now do reverse contacts - no need to count internal ones again */
            cr2_ptr = *cr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s1_s || (*cr2_ptr).res_num > s1_e) {
                    (s_conts->s1_ext)++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
/* now do reverse beta sheet */
            cr2_ptr = *cbr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s1_s || (*cr2_ptr).res_num > s1_e) {
                    (s_conts->s1_ext)++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
        } /*if*/
        i++;
        cf1_ptr = (cf1_ptr + 1);
        cr1_ptr = (cr1_ptr + 1);
        cbf1_ptr = (cbf1_ptr + 1);
        cbr1_ptr = (cbr1_ptr + 1);
    } /*while*/

/* now scan s2 to work out s2_int s2_ext s2_sht_ext s2_sht_int */
    i = s2_s;
    cf1_ptr = (contact_info + s2_s);
    cr1_ptr = (contact_rev_info + s2_s);
    cbf1_ptr = (beta_l + s2_s);
    cbr1_ptr = (rev_beta_l + s2_s);
    while (i <= s2_e) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s2_s && (*cf2_ptr).res_num <= s2_e) {
                    (s_conts->s2_int)++;
                } else {
                    (s_conts->s2_ext)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* do forward beta sheet */
            cf2_ptr = *cbf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s2_s && (*cf2_ptr).res_num <= s2_e) {
                    (s_conts->s2_sht_int)++;
                } else {
                    (s_conts->s2_sht_ext)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* now do reverse contacts - no need to count internal ones again */
            cr2_ptr = *cr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s2_s || (*cr2_ptr).res_num > s2_e) {
                    (s_conts->s2_ext)++;
                } /*if*/
                if ((*cr2_ptr).res_num < s2_s && (*cr2_ptr).res_num > s1_e) {
                    sb_extra++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
/* reverse beta sheet contacts */
            cr2_ptr = *cbr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s2_s || (*cr2_ptr).res_num > s2_e) {
                    (s_conts->s2_sht_ext)++;
                } /*if*/
                if ((*cr2_ptr).res_num < s2_s && (*cr2_ptr).res_num > s1_e) {
                    sb_sht_extra++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        cr1_ptr = (cr1_ptr + 1);
        cbf1_ptr = (cbf1_ptr + 1);
        cbr1_ptr = (cbr1_ptr + 1);
        i++;
    } /*while*/
/* now count segement b internal contacts */
    i = s1_e + 1;
    cf1_ptr = (contact_info + i);
    while (i < s2_s) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num < s2_s) {
                    sb_int++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        i++;
    } /*while*/

/* check sb has no big contacts with s1 */
    value = asd_calc_c_value(s_conts->s1_int, sb_int, sb1_extra, sb1_sht_extra,
                             s1_s, s1_e, 0, 0, (s1_e + 1), (s2_s - 1), 0, 0);

    if ((ss_only && value < params.MIN_PEAK_SS_ONLY_C) ||
       (!ss_only && value < params.MIN_PEAK_C)) {
        return(2);
    } /*if*/

/* check sb has no big contacts with s2 */
    value = asd_calc_c_value(s_conts->s2_int, sb_int, sb_extra, sb_sht_extra,
                             s2_s, s2_e, 0, 0, (s1_e + 1), (s2_s - 1), 0, 0);

    if ((ss_only && value < params.MIN_PEAK_SS_ONLY_C) ||
       (!ss_only && value < params.MIN_PEAK_C)) {
        return(2);
    } /*if*/

/* check bits left over if size < params.MIN_NO_CONTACT_CUTOFF */
/* one part left over will not occur at this stage */
    if (s1_s == d_to_split->start1 && s2_e == d_to_split->end1) {
        ;
/* if two parts left over they must be correlated if one or both is less than
   params.MIN_NO_CONTACT_CUTOFF in addition the total size must be > MIN_DOMAIN_SIZE */
    } else if (s1_s == d_to_split->start1) {
        d_left_over->start1 = s1_e + 1;
        d_left_over->end1 = s2_s - 1;
        d_left_over[1].start1 = s2_e + 1;
        d_left_over[1].end1 = d_to_split->end1;
        size1 = d_left_over->end1 - d_left_over->start1 + 1; 
        size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1; 
        if (d_to_split->end1 != end_chain) {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_sc_correlation(contact_info, contact_rev_info,
                     bn, d_left_over, 2, &sc_seg_info, ss, ss_only, c_list)) {
                    return(2);
                } else {
                    sc_corr = 1;
                    d_sc_corr.start1 = d_left_over->start1;
                    d_sc_corr.end1 = d_left_over->end1;
                } /*if*/
            } /*if*/
        } else {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_END) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_sc_correlation(contact_info, contact_rev_info,
                       bn, d_left_over, 2, &sc_seg_info, ss, ss_only, c_list)) {
                    return(2);
                } else {
                    sc_corr = 1;
                    d_sc_corr.start1 = d_left_over->start1;
                    d_sc_corr.end1 = d_left_over->end1;
                } /*if*/
            } /*if*/
        } /*if*/
    } else if (s2_e == d_to_split->end1) {
        d_left_over->start1 = d_to_split->start1;
        d_left_over->end1 = s1_s - 1;
        d_left_over[1].start1 = s1_e + 1;
        d_left_over[1].end1 = s2_s - 1;
        size1 = d_left_over->end1 - d_left_over->start1 + 1;
        size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
        if (d_to_split->start1 != start_chain) {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_correlation(contact_info, contact_rev_info, bn,
                                      d_left_over, ss, 2, c_list)) {
                    return(2);
                } /*if*/
            } /*if*/
        } else {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_END ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_correlation(contact_info, contact_rev_info, bn,
                                      d_left_over, ss, 2, c_list)) {
                    return(2);
                } /*if*/
            } /*if*/
        } /*if*/
/* else if three parts left over */
    } else {
        d_left_over->start1 = d_to_split->start1;
        d_left_over->end1 = s1_s - 1;
        d_left_over[1].start1 = s1_e + 1;
        d_left_over[1].end1 = s2_s - 1;
        d_left_over[2].start1 = s2_e + 1;
        d_left_over[2].end1 = d_to_split->end1;
        if (asd_check_sc_correlation(contact_info, contact_rev_info, bn,
                    d_left_over, 3, &sc_seg_info, ss, ss_only, c_list)) {
            size1 = d_left_over->end1 - d_left_over->start1 + 1;
            size2 = d_left_over->end2 - d_left_over->start2 + 1;
            size3 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
            if (d_left_over->end2 == d_to_split->end1) {
/*
 * segement c is one of the correlated parts and either it or the part it is
 * correlated with are less then params.MIN_NO_CONTACT_CUTOFF then mark as sc_corr = 1
 */
                if ((size1 < params.MIN_NO_CONTACT_CUTOFF_END &&
                     d_left_over->start1 == start_chain) ||
                    (size1 < params.MIN_NO_CONTACT_CUTOFF_MID &&
                     d_left_over->start1 != start_chain) ||
                    (size2 < params.MIN_NO_CONTACT_CUTOFF_END &&
                     d_left_over->end2 == end_chain) ||
                    (size2 < params.MIN_NO_CONTACT_CUTOFF_MID &&
                     d_left_over->end2 != end_chain)) {
                    sc_corr = 1;
                    d_sc_corr.start1 = d_left_over->start1;
                    d_sc_corr.end1 = d_left_over->end1;
                } /*if*/
            } /*if*/
            if ((size1 + size2) < params.MIN_DOMAIN_SIZE ||
                (size3 < params.MIN_NO_CONTACT_CUTOFF_END && (d_left_over[1].end1 ==
                 end_chain || d_left_over[1].start1 == start_chain)) ||
                (size3 < params.MIN_NO_CONTACT_CUTOFF_MID && (d_left_over[1].end1 !=
                 end_chain && d_left_over[1].start1 != start_chain))) {
                return(2);
            } /*if*/
        } else {
            size1 = d_left_over->end1 - d_left_over->start1 + 1;
            size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
            size3 = d_left_over[2].end1 - d_left_over[2].start1 + 1;
            if (d_left_over->start1 == start_chain &&
                d_left_over[2].end1 == end_chain) {
                if (size1 < params.MIN_NO_CONTACT_CUTOFF_END ||
                    size2 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size3 < params.MIN_NO_CONTACT_CUTOFF_END) {
                    return(2);
                } /*if*/
            } else if (d_left_over->start1 == start_chain) {
                if (size1 < params.MIN_NO_CONTACT_CUTOFF_END ||
                    size2 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size3 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                    return(2);
                } /*if*/
            } else if (d_left_over[2].end1 == end_chain) {
                if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size2 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size3 < params.MIN_NO_CONTACT_CUTOFF_END) {
                    return(2);
                } /*if*/
            } else {
                if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size2 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                    size3 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                    return(2);
                } /*if*/
            } /*if*/
        } /*if*/
    } /*if*/

    return(0);
} /*asd_calc_res_from_scratch_m*/

/*
 * Name
 *   asd_calc_res_given_m
 * Purpose
 *   given an a change in s2_e calculate the new contacts for multi cut senario
 *   ASSUMES s1 is before s2
 *   the only change that can be made is to the end of s2 and that it is made
 *   larger
 *   must have called asd_cal_res_from_scratch_m first with only s2_e being
 *   allowed to change
 */
int
asd_calc_res_given_m(Asd_Contact_Info **c1,
                     Asd_Contact_Info **c2,
                     Asd_Domain *d_to_split, Asd_Domain *max_domain_m,
                     Asd_Seg_Cont *s_conts, bool_t ss_only, char *ss,
                     int start_chain, int end_chain,
                     int s1_sn, int s1_en, int s2_sn, int s2_en,
                     int s1_s,  int s1_e,  int s2_s,  int s2_e,
                     int total_contacts, struct brookn *bn,
                     Asd_Contact_List *c_list, int increment)
{
    int i;                      /* loop counter                          */
    int j;                      /* loop counter                          */
    int size1;                  /* size of segment                       */
    int size2;                  /* size of segment                       */
    int num_contacts;           /* number of contacts for that item      */
    int int_1;                  /* number of internal contacts           */
    int int_2;                  /* number of internal contacts           */
    float ext_no;               /* number of external contacts           */
    int ext_sht;                /* external sheet contacts               */
    float value;                /* temporary value                       */
    Asd_Domain *d_left_over;    /* domain left over                      */
    Asd_Domain d_l_over[3];     /* domain left over                      */
    Asd_Contact_Info **cf1_ptr; /* temporary pointer to forward contacts */
    Asd_Contact_Info *cf2_ptr; /* temporary pointer to forward contacts */
    Asd_Contact_Info **cr1_ptr; /* temporary pointer to reverse contacts */
    Asd_Contact_Info *cr2_ptr; /* temporary pointer to reverse contacts */
    Asd_Contact_Info **cbf1_ptr; /* temporary pointer to forward contacts */
    Asd_Contact_Info **cbr1_ptr; /* temporary pointer to r b     contacts */
    Asd_Contact_Info **contact_info;  /* beta sheet list                 */
    Asd_Contact_Info **contact_rev_info;  /* reverse beta sheet list     */
    Asd_Contact_Info **beta_l;  /* beta sheet list                       */
    Asd_Contact_Info **rev_beta_l;  /* reverse beta sheet list           */

    contact_info = c_list->cl;
    contact_rev_info = c_list->rcl;
    beta_l = c_list->bl;
    rev_beta_l = c_list->rbl;

    if (s1_sn != s1_s || s1_en != s1_e || s2_sn != s2_s || s2_en < s2_e) {
        ase_error_fatal("asd_calc_res_given_m", "function called incorrectly");
    } /*if*/

    if ((s2_en - s2_sn + s1_en - s1_sn + 2) < params.MIN_DOMAIN_SIZE) {
        return (1);
    } /*if*/

/* check bits left over if size < params.MIN_NO_CONTACT_CUTOFF */
/* if one part left over */
/* in this case the part left over must be >= params.MIN_NO_CONTACT_CUTOFF_MID */
/* all other cases of 2 or 3 bits left over will be trapped by initialise
 * routine first
 * EXCEPT for the bit where you have three parts left over going into 2
 */
    d_left_over = d_l_over;
    if (s1_sn == d_to_split->start1 && s2_en == d_to_split->end1) {
        if ((s2_sn - s1_en - 1) < params.MIN_NO_CONTACT_CUTOFF_MID) {
            return(2);
        } /*if*/
    } else if (s2_en == d_to_split->end1) {
        d_left_over->start1 = d_to_split->start1;
        d_left_over->end1 = s1_sn - 1;
        d_left_over[1].start1 = s1_en + 1;
        d_left_over[1].end1 = s2_sn - 1;
        size1 = d_left_over->end1 - d_left_over->start1 + 1;
        size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
        if (d_to_split->start1 != start_chain) {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_MID) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_correlation(contact_info, contact_rev_info, bn,
                                      d_left_over, ss, 2, c_list)) {
                    return(2);
                } /*if*/
            } /*if*/
        } else {
            if (size1 < params.MIN_NO_CONTACT_CUTOFF_MID ||
                size2 < params.MIN_NO_CONTACT_CUTOFF_END) {
                if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                    return(2);
                } /*if*/
                if (!asd_check_correlation(contact_info, contact_rev_info, bn,
                                      d_left_over, ss, 2, c_list)) {
                    return(2);
                } /*if*/
            } /*if*/
        } /*if*/
    } /*if*/

/* obviously s1_int and s1_ext s1_int_sht s1_sht_ext stay the same */
/* only need to modify the corresponding s2 variables */
    i = s2_e + 1;
    cf1_ptr = (contact_info + (s2_e + 1));
    cr1_ptr = (contact_rev_info + (s2_e + 1));;
    cbf1_ptr = (beta_l + (s2_e + 1));
    cbr1_ptr = (rev_beta_l + (s2_e + 1));
    while (i <= s2_en) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s2_sn && (*cf2_ptr).res_num
                                                                     <= s2_en) {
                    (s_conts->s2_int)++;
                } else {
                    (s_conts->s2_ext)++;
                } /*if*/
                if (sc_corr) {
/* all forward contacts here would have been part of sc */
                    (sc_seg_info.s2_int)--;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* now do forward beta */
            cf2_ptr = *cbf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s2_sn &&
                    (*cf2_ptr).res_num <= s2_en) {
                    (s_conts->s2_sht_int)++;
                } else {
                    (s_conts->s2_sht_ext)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* now do reverse contacts - add externals also remove add extra internals
   and remove them from externals */
            cr2_ptr = *cr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num >= s1_sn &&
                    (*cr2_ptr).res_num <= s1_en) {
                    (s_conts->s1_s2_cont)++;
                } /*if*/
                if ((*cr2_ptr).res_num < s2_sn || (*cr2_ptr).res_num > s2_en) {
                    (s_conts->s2_ext)++;
                } else if ((*cr2_ptr).res_num >= s2_sn  &&
                           (*cr2_ptr).res_num <= s2_e) {
                    (s_conts->s2_int)++;
                    (s_conts->s2_ext)--;
                } /*if*/
                if (sc_corr) {
                    if ((*cr2_ptr).res_num >= d_sc_corr.start1 &&
                        (*cr2_ptr).res_num <= d_sc_corr.end1) {
                        (sc_seg_info.s1_s2_cont)--;
                    } /*if*/
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
/* now do beta reverse contacts - add externals also remove add extra internals
   and remove them from externals */
            cr2_ptr = *cbr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num >= s1_sn &&
                    (*cr2_ptr).res_num <= s1_en) {
                    (s_conts->s1_s2_sht_cont)++;
                } /*if*/
                if ((*cr2_ptr).res_num < s2_sn || (*cr2_ptr).res_num > s2_en) {
                    (s_conts->s2_sht_ext)++;
                } else if ((*cr2_ptr).res_num >= s2_sn  &&
                           (*cr2_ptr).res_num <= s2_e) {
                    (s_conts->s2_sht_int)++;
                    (s_conts->s2_sht_ext)--;
                } /*if*/
                if (sc_corr) {
                    if ((*cr2_ptr).res_num >= d_sc_corr.start1 &&
                        (*cr2_ptr).res_num <= d_sc_corr.end1) {
                        (sc_seg_info.s1_s2_sht_cont)--;
                    } /*if*/
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        cr1_ptr = (cr1_ptr + 1);
        cbf1_ptr = (cbf1_ptr + 1);
        cbr1_ptr = (cbr1_ptr + 1);
        i++;
    } /*while*/

/* now analyse rest*/

/* if no intersegment contacts then parts uncorrelated */
    if (!s_conts->s1_s2_cont) {
        return(0);
    } /*if*/
/* check parts are correlated if not return as false */
    value = asd_calc_c_value(s_conts->s1_int, s_conts->s2_int,
                             s_conts->s1_s2_cont, s_conts->s1_s2_sht_cont,
                             s1_sn, s1_en, 0, 0, s2_sn, s2_en, 0, 0);
    if (! ((ss_only && value < params.MIN_PEAK_SS_ONLY_DC) ||
          (!ss_only && value < params.MIN_PEAK_DC))) {
        return(0);
    } /*if*/
/* now check out sc contacts */
    if (sc_corr) {
        size1 = d_sc_corr.end1 - d_sc_corr.start1 + 1;
        size2 = d_to_split->end1 - s2_en;
        if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
            return(2);
        } /*if*/
        if (((d_to_split->end1 - s2_en) < params.MIN_SEGMENT_SIZE_END &&
              d_to_split->end1 == end_chain) ||
            ((d_to_split->end1 - s2_en) < params.MIN_SEGMENT_SIZE_MID &&
              d_to_split->end1 != end_chain)) {
            return(0);
        } /*if*/
        value = asd_calc_c_value(sc_seg_info.s1_int, sc_seg_info.s2_int,
                                 sc_seg_info.s1_s2_cont,
                                 sc_seg_info.s1_s2_sht_cont,
                                 d_sc_corr.start1, d_sc_corr.end1, 0, 0,
                                 (s2_en + 1), d_to_split->end1, 0, 0);
        if ((ss_only && value >= params.MIN_PEAK_SS_ONLY_DC) ||
           (!ss_only && value >= params.MIN_PEAK_DC)) {
            return(0);
        } /*if*/
/* check cases where sc has become smaller than params.MIN_NO_CONTACT_CUTOFF */
/* first for 2 bits left over and then for 3 bits left over */
    } else if (s1_sn == d_to_split->start1 && s2_en == d_to_split->end1) {
        ;
    } else if (((d_to_split->end1 - s2_en) < params.MIN_NO_CONTACT_CUTOFF_END &&
                 d_to_split->end1 == end_chain) ||
               ((d_to_split->end1 - s2_en) < params.MIN_NO_CONTACT_CUTOFF_MID &&
                 d_to_split->end1 != end_chain) && s2_en != d_to_split->end1) {
        if (d_to_split->start1 == s1_sn) {
            d_left_over->start1 = s1_en + 1;
            d_left_over->end1 = s2_sn - 1;
            d_left_over[1].start1 = s2_en + 1;
            d_left_over[1].end1 = d_to_split->end1;
            size1 = d_left_over->end1 - d_left_over->start1 + 1;
            size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
            if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                return(2);
            } /*if*/
            if (asd_check_sc_correlation(contact_info, contact_rev_info,
                       bn, d_left_over, 2, &sc_seg_info, ss, ss_only, c_list)) {
                sc_corr = 1;
                d_sc_corr.start1 = d_left_over->start1;
                d_sc_corr.end1 = d_left_over->end1;
            } else {
                return(0);
            } /*if*/
        } else if (d_to_split->end1 == s2_en) {
            d_left_over->start1 = d_to_split->start1;
            d_left_over->end1 = s1_sn - 1;
            d_left_over[1].start1 = s1_en + 1;
            d_left_over[1].end1 = s2_sn - 1;
            size1 = d_left_over->end1 - d_left_over->start1 + 1;
            size2 = d_left_over[1].end1 - d_left_over[1].start1 + 1;
            if ((size1 + size2) < params.MIN_DOMAIN_SIZE) {
                return(2);
            } /*if*/
            if (!asd_check_correlation(contact_info, contact_rev_info, bn,
                                      d_left_over, ss, 2, c_list)) {
                return(0);
            } /*if*/
/* 3 bits left over */
        } else {
            d_left_over->start1 = d_to_split->start1;
            d_left_over->end1 = s1_sn - 1;
            d_left_over[1].start1 = s1_en + 1;
            d_left_over[1].end1 = s2_sn - 1;
            d_left_over[2].start1 = s2_en + 1;
            d_left_over[2].end1 = d_to_split->end1;
            if (asd_check_sc_correlation(contact_info, contact_rev_info, bn,
                          d_left_over, 3, &sc_seg_info, ss, ss_only, c_list)) {
                sc_corr = 1;
                d_sc_corr.start1 = d_left_over->start1;
                d_sc_corr.end1 = d_left_over->end1;
            } else {
                return(0);
            } /*if*/
        } /*if*/
    } /*if*/

/* now work out value of split */
    int_1 = s_conts->s1_int + s_conts->s2_int + s_conts->s1_s2_sht_cont;
    ext_no = s_conts->s2_ext + s_conts->s1_ext - (2 * s_conts->s1_s2_cont);
    int_2 = total_contacts - int_1 - ext_no;

    ext_sht = s_conts->s2_sht_ext + s_conts->s1_sht_ext -
                              (2 * s_conts->s1_s2_sht_cont);

    value = asd_calc_d_value(int_1, int_2, ext_no, ext_sht, d_to_split,
                             s1_sn, s1_en, s2_sn, s2_en);

    if (value > max_domain_m->value) {
        if ((ss_only && value >= params.MIN_PEAK_SS_ONLY_MC) ||
           (!ss_only && value >= params.MIN_PEAK_MC) || 1) {
            max_domain_m->value = value;
            if (increment == 1) {
                max_domain_m->range.s1_s_min = s1_sn; 
                max_domain_m->range.s1_e_min = s1_en; 
                max_domain_m->range.s2_s_min = s2_sn; 
                max_domain_m->range.s2_e_min = s2_en; 
                max_domain_m->range.s1_s_max = s1_sn;
                max_domain_m->range.s1_e_max = s1_en;
                max_domain_m->range.s2_s_max = s2_sn;
                max_domain_m->range.s2_e_max = s2_en;
            } else {
                max_domain_m->range.s1_s_min = s1_sn - increment + 1;
                max_domain_m->range.s1_s_max = s1_sn + increment - 1;
                if (max_domain_m->range.s1_s_min < d_to_split->start1 ||
                    s1_sn == d_to_split->start1) {
                    max_domain_m->range.s1_s_min = d_to_split->start1;
                    max_domain_m->range.s1_s_max = d_to_split->start1;
                } /*if*/
 
                max_domain_m->range.s1_e_min = s1_en - increment + 1;
                max_domain_m->range.s1_e_max = s1_en + increment - 1;

                max_domain_m->range.s2_s_min = s2_sn - increment + 1;
                max_domain_m->range.s2_s_max = s2_sn + increment - 1;

                max_domain_m->range.s2_e_min = s2_en - increment + 1;
                max_domain_m->range.s2_e_max = s2_en + increment - 1;
                if (max_domain_m->range.s2_e_max > d_to_split->end1 ||
                    s2_en == d_to_split->end1) {
                    max_domain_m->range.s2_e_max = d_to_split->end1;
                    max_domain_m->range.s2_e_min = d_to_split->end1;
                } /*if*/
            } /*if*/
            if (ss_only) {
                if (s1_sn != d_to_split->start1) {
                    i = max_domain_m->range.s1_s_max - 1;
                    i++;
                    while (ss[i] != 'H' &&
                           ss[i] != 'E' && i < d_to_split->end1) {
                        i++;
                    } /*while*/
                    max_domain_m->range.s1_s_max = i;
    
                    i = max_domain_m->range.s1_s_min - 1;
                    i--;
                    while (ss[i] != 'H' &&
                           ss[i] != 'E' && i > (d_to_split->start1 - 1)) {
                        i--;
                    } /*while*/
                    i++;
                    max_domain_m->range.s1_s_min = i;
                } /*if*/

                i = max_domain_m->range.s1_e_max - 1;
                i++;
                while (ss[i] != 'H' && ss[i] != 'E' && i < d_to_split->end1) {
                    i++;
                } /*while*/
                max_domain_m->range.s1_e_max = i;

                i = max_domain_m->range.s1_e_min - 1;
                i--;
                while (ss[i] != 'H' && ss[i] != 'E' && i >
                                                     (d_to_split->start1 - 1)) {
                    i--;
                } /*while*/
                i++;
                max_domain_m->range.s1_e_min = i;

                i = max_domain_m->range.s2_s_max - 1;
                i++;
                while (ss[i] != 'H' && ss[i] != 'E' && i < d_to_split->end1) {
                    i++;
                } /*while*/
                max_domain_m->range.s2_s_max = i;

                i = max_domain_m->range.s2_s_min - 1;
                i--;
                while (ss[i] != 'H' && ss[i] != 'E' && i >
                                                     (d_to_split->start1 - 1)) {
                    i--;
                } /*while*/
                i++;
                max_domain_m->range.s2_s_min = i;

                if (s2_en != d_to_split->end1) {
                    i = max_domain_m->range.s2_e_max - 1;
                    i++;
                    while (ss[i] != 'H' &&
                           ss[i] != 'E' && i < d_to_split->end1) {
                        i++;
                    } /*while*/
                    max_domain_m->range.s2_e_max = i;

                    i = max_domain_m->range.s2_e_min - 1;
                    i--;
                    while (ss[i] != 'H' &&
                           ss[i] != 'E' && i > (d_to_split->start1 - 1)) {
                        i--;
                    } /*while*/
                    i++;
                    max_domain_m->range.s2_e_min = i;
                } /*if*/
            } /*if*/
        } /*if*/
    } /*if*/

    return(0);
} /*asd_calc_res_given_m*/
