/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *     asd_glob_interface.h
 * Purpose
 *     header file for asd_contacts_utils.c
 * Author
 *     Asim Siddiqui
 * SccsId
 *     %W%   %U%   %E%
 */

#ifndef HAVE_ASD_GLOB_INTERFACE_H
#define HAVE_ASD_GLOB_INTERFACE_H

#include <rdssp.h>
#include <asd_structs.h>
#include <glob_routs.h>

Asd_Domain_List *
asd_check_globularity(Asd_Domain_List *d_list1, Asd_Domain_List *d_list2,
                      Asd_Domain_List *d_list3, Asd_Domain_List *d_list4,
                      struct brookn *bn, Asd_Domain *d_orig);

void
asd_analyse_bits_left_over(Asd_Domain *d_to_split, Asd_Domain_List *d_list,
                           Asd_Contact_Info **contact_info,
                           Asd_Contact_Info **contact_rev_info,
                           struct brookn *bn, char *ss);

void
asd_check_glob_end(Asd_Domain *d_to_split, Asd_Domain_List *d_list,
                   Asd_Contact_Info **contact_info,
                   Asd_Contact_Info **contact_rev_info,
                   struct brookn *bn, char *ss);

#endif /*HAVE_ASD_GLOB_INTERFACE_H*/
