/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *    asd_structs.h
 * Purpose
 *    to provide a list of structures for the domak routines
 * Author
 *    Asim Siddiqui
 * SccsId
 *    %W%   %U%   %E%
 */
#include <rdssp.h>
#include <local.h>

#ifndef HAVE_ASD_STRUCTS_H
#define HAVE_ASD_STRUCTS_H

typedef struct {
    int res_num; /* residue contact number */
    char ctype;  /* contact type           */
} Asd_Contact_Info;

typedef struct {
    Asd_Contact_Info **cl;  /* contact list            */
    Asd_Contact_Info **rcl; /* reverse contact list    */
    Asd_Contact_Info **bl;  /* beta sheet list         */
    Asd_Contact_Info **rbl; /* reverse beta sheet list */
} Asd_Contact_List;

typedef struct {
    int s1_s_max; /* segment 1 start max range */
    int s1_s_min; /* segment 1 start min range */
    int s1_e_max; /* segment 1 end max range   */
    int s1_e_min; /* segment 1 end min range   */
    int s2_s_max; /* segment 2 start max range */
    int s2_s_min; /* segment 2 start min range */
    int s2_e_max; /* segment 2 end max range   */
    int s2_e_min; /* segment 2 end min range   */
} Asd_Range_Info;
    

typedef struct {
    int start1;           /* first position in domain                    */
    int end1;             /* last position in domain                     */
    int start2;           /* first position in domain                    */
    int end2;             /* last position in domain                     */
    int type;             /* one domain or two                           */
    int d_assigned;       /* if bit left over domain no. its assigned to */
    float value;          /* cut value                                   */
    float glob;           /* globularity                                 */
    Asd_Range_Info range; /* info on range of cuts with same value       */
    char *id;             /* domain identifier                           */
    bool_t ok;            /* is domain ok                                */
} Asd_Domain;

typedef struct {
    char cid;  /* chain indentifier    */
    int start; /* start contact number */
    int end;   /* end contact number   */
} Asd_Chain_Info;

typedef struct {
    int s1_int;         /* s1 internal contacts              */
    int s2_int;         /* s2 internal contacts              */
    int s1_ext;         /* s1 external contacts              */
    int s2_ext;         /* s2 external contacts              */
    int s1_s2_cont;     /* s1-s2 intersegment contacts       */
    int s1_sht_int;     /* s1 internal sheet contacts        */
    int s2_sht_int;     /* s2 internal sheet contacts        */
    int s1_sht_ext;     /* s1 external sheet contacts        */
    int s2_sht_ext;     /* s2 external sheet contacts        */
    int s1_s2_sht_cont; /* s1-s2 intersegment sheet contacts */
} Asd_Seg_Cont;

typedef struct {
    Asd_Domain *domains;        /* list of domains                  */
    Asd_Domain *d_split_up;     /* domain which was split up        */
    int n_d_list;               /* number of domains in domain list */
    Asd_Domain *bits_left_over; /* list of left over bits           */
    int n_b_left_over;          /* number of left over bits         */
} Asd_Domain_List;

typedef struct {
    int start;     /* start of helix                  */
    int end;       /* end of helix                    */
    int length;    /* lenght of helix                 */
    int hel_ramp;  /* helix ramp                      */
    float c_dens;  /* contact density corrected       */
    float area;    /* area under function             */
} Asd_Helix_Info;

typedef struct {
     int MIN_DOMAIN_SIZE;
     int MIN_SEGMENT_SIZE_END;
     int MIN_SEGMENT_SIZE_MID;
     int MIN_DOUBLE_SPLIT;
     int MIN_NO_CONTACT_CUTOFF_MID;
     int MIN_NO_CONTACT_CUTOFF_END;
     float E_WEIGHT;

     float MAX_ALLOWABLE_GLOB;

     float MIN_PEAK_SS_ONLY_C;
     float MIN_PEAK_C;
     float MIN_PEAK_SS_ONLY_DC;
     float MIN_PEAK_DC;
     float MIN_PEAK_SS_ONLY_MC;
     float MIN_PEAK_MC;

     float MIN_PEAK_BLO_C;
     float MIN_PEAK_SS_ONLY_BLO_C;
     float MIN_PEAK_BLO_DC;
     float MIN_PEAK_SS_ONLY_BLO_DC;

     float MIN_SS_PER;

     int MIN_HELIX_LENGTH;
     int HELIX_RAMP;
     float HELIX_REDUCE_C_DENS;

     int INCREMENT_DIVIDER;
} Asd_Parameters;

Asd_Parameters params;

#endif /*HAVE_ASD_STRUCTS_H*/
