/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *     asd_utils.h
 * Author
 *     Asim Siddiqui
 * SccsId
 *     %W%   %U%   %E%
 */

#ifndef HAVE_ASD_UTILS_H
#define HAVE_ASD_UTILS_H

#include <rdssp.h>
#include <asd_structs.h>
#include <local.h>

bool_t
asd_ss_per(char *ss, Asd_Domain *d_to_split, int *increment);

bool_t
asd_check_correlation(Asd_Contact_Info **contact_info,
                      Asd_Contact_Info **contact_rev_info,
                      struct brookn *bn, Asd_Domain *d_to_check, char *ss,
                      int num_domains, Asd_Contact_List *c_list);

bool_t
asd_check_sc_correlation(Asd_Contact_Info **contact_info,
                         Asd_Contact_Info **contact_rev_info,
                         struct brookn *bn, Asd_Domain *d_to_check,
                         int num_domains, Asd_Seg_Cont *sc_seg_info,
                         char *ss, bool_t ss_only, Asd_Contact_List *c_list);

Asd_Contact_List *
asd_total_contacts(Asd_Domain *d_to_calc, char *ss, bool_t ss_only,
                   Asd_Contact_Info **contact_info,
                   Asd_Contact_Info **contact_rev_info, struct brookn *bn,
                   int *total_contacts);

void
asd_focus_range(Asd_Domain *d_to_focus, Asd_Domain *d_to_split,
                Asd_Contact_Info **contact_info,
                Asd_Contact_Info **contact_rev_info, struct brookn *bn,
                int start_chain, int end_chain, char *ss);

void
asd_free_c_list(Asd_Domain *d_to_free, Asd_Contact_List *c_list);

float
asd_complete_corr(Asd_Contact_Info **contact_info,
                  Asd_Contact_Info **contact_rev_info,
                  struct brookn *bn, char *ss, Asd_Domain_List *d_list,
                  int d1, int d2);

#endif /*HAVE_ASD_UTILS_H*/
