/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell


 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <rdssp.h>
#include <rbr_newlib.h>

/* Given an open file pointer for a binary contacts file, this
 *  routine contains a buffer string that would correspond to 
 *  reading the old ASCII format line by line 
 * The string *buff must be allocated already for about 100 characters 
 *  
 * The routine returns -1 if an error (i.e. FEOF or FERROR) is
 *  encountered, 1 is returned if a correct end of file is
 *  encountered (i.e., after the last contact has been read in)
 *  otherwise 0 is returned (i.e., more of the file is to be read) */

int RBR_readcbin(buff,IN,OUTPUT)
char *buff;
FILE *IN,*OUTPUT;
{

	char sec1,sec2,ctype,aa1_1,aa1_2;
	char at1[6],at2[6];
	char *aa3_1,*aa3_2;

	int i,len;
	int end;
	int counter,cnum1,cnum2,atnum1,atnum2;
	int ret_value;

	float dist;

	struct brookn brk1,brk2;

	if(buff==NULL) { 
	  fprintf(OUTPUT,"error: buff is not allocate\n");
	  return -1;
	}
	strcpy(&at1[0],"\0\0\0\0");
	strcpy(&at2[0],"\0\0\0\0");

	/* Binary input */
	ret_value=0;

	fread(&counter,sizeof(int),1,IN); if(feof(IN)!=0 || ferror(IN)!=0) return 1; /* normal exit */

	/* Atom one info */
	fread(&aa1_1,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; /* error in reading */
	fread(&cnum1,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk1.cid,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk1.n,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk1.in,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&at1[0],sizeof(char),4,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	      
	      
	fread(&atnum1,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&sec1,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 

	/* Atom two info */
	fread(&aa1_2,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&cnum2,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk2.cid,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk2.n,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&brk2.in,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&at2[0],sizeof(char),4,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&atnum2,sizeof(int),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&aa1_2,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&sec2,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 

	/* Contact info */
	fread(&ctype,sizeof(char),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	fread(&dist,sizeof(float),1,IN);  if(feof(IN)!=0 || ferror(IN)!=0) return -1; 
	at1[4]=at2[4]='\0';

	aa3_1=RBR_a1to3(aa1_1);   /* the memory for these strings is allocated in a1to3() */
	aa3_2=RBR_a1to3(aa1_2); 
	
	sprintf(buff,"%4d %s %4d %c %4d %c %4s %5d %c  %s %4d %c %4d %c %4s %5d %c  %c %4.2f \n", 
	      counter,
	      aa3_1,cnum1,brk1.cid,brk1.n,brk1.in,at1,atnum1,sec1,
	      aa3_2,cnum2,brk2.cid,brk2.n,brk2.in,at2,atnum2,sec2,
	      ctype,dist);

	free(aa3_1); free(aa3_2);

	return 0;

}
