/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Asim S. Siddiqui

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *   asm_mop.c
 * SccsId
 *   %W%   %U%   %E%
 * Puprose:
 *   To provide memory handling routines
 */

#include <stdio.h>
#include <malloc.h>
#include <ase_error.h>
#include <asm_mop.h>

/*
 * name
 *     asm_malloc
 * purpose:
 *     allocate memory as required
 */
void *
asm_malloc(size_t size)
{
    void *ptr;
    ptr = malloc(size);

    if (ptr == NULL) {
        ase_error_fatal("as_realloc", "out of memory");
    } /*if*/

    return (ptr);
} /*asm_realloc*/

/*
 * name
 *     asm_realloc
 * purpose:
 *     allocate/reallocate memory as required
 */
void *
asm_realloc(void *ptr, size_t size)
{
    if (ptr == NULL) {
        ptr = malloc(size);
    } else {
        ptr = realloc(ptr, size);
    } /*if*/
    if (ptr == NULL) {
        ase_error_fatal("as_realloc", "out of memory");
    } /*if*/
    return(ptr);
} /*asm_realloc*/
