/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Asim S. Siddiqui

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *    asstr_util.c
 * Purpose
 *    to provide a set of string utility routines
 * Author
 *    Asim Siddiqui
 * SccsId
 *    %W%   %U%   %E%
 */
#include <string.h>
#include <malloc.h>
#include <asm_mop.h>
#include <asstr_util.h>

/*
 * name
 *    asstr_save
 * purpose
 *    allocate memory for the given string, return pointer to it
 */
char *
asstr_save(char *string)
{
    char *ret_string;

    ret_string = (char *) asm_malloc(sizeof(char) * (strlen(string) + 1));

    strcpy(ret_string, string);

    return(ret_string);
} /*asstr_save*/

/*
 * name
 *    asstr_cat_safe
 * purpose
 *    to append one string to another allocating memory for the new string
 */
char *
asstr_cat_safe(char *s1, char *s2)
{
    s1 = (char *) asm_realloc(s1, sizeof(char) * (strlen(s1) + strlen(s2)+ 1));

    strcat(s1, s2);

    return(s1);
} /*asstr_cat_safe*/
