/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <malloc.h>

#define RBR_a1to3_acids3 "ALA ASX CYS ASP GLU PHE GLY HIS ILE ___ LYS LEU MET ASN ___ PRO GLN ARG SER THR ___ VAL TRP UNK TYR GLX ___ ___ ___ ___ ___ ___ ___ ___ CYH ___ ___ ___ ___ HET"
#define RBR_a1to3_acids1 "ABCDEFGHI_KLMN_PQRST_VWXYZ________c____h"

/* Converts one letter amino acid code to three letter
 *  amino acid code 
 * Note: CYS refers to cystine, CYH refers to cysteine */

char *RBR_a1to3(a1)
char a1;
{
	int i;
	char *a3;
	
	a3=(char*)malloc(4*sizeof(char));

	if(a1<'A' || a1 > 'h') a1='X';
	strncpy(&a3[0],&RBR_a1to3_acids3[(a1-'A')*4],3);
	a3[3]='\0';

	return a3;

}
